/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.webpieces.util.exceptions.SneakyThrow;

public class TxCompleters {
    public void commit(EntityTransaction tx, EntityManager em) {
        try {
            tx.commit();
            em.close();
        }
        catch (Throwable e) {
            this.closeEm(e, em);
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    public void rollbackCloseSuppress(Throwable t, EntityManager mgr, EntityTransaction tx) {
        this.rollbackTx(t, tx);
        this.closeEm(t, mgr);
    }

    public void rollbackTx(Throwable t, EntityTransaction tx) {
        try {
            tx.rollback();
        }
        catch (Throwable e) {
            t.addSuppressed(e);
        }
    }

    public void closeEm(Throwable t, EntityManager em) {
        try {
            em.close();
        }
        catch (Throwable e) {
            t.addSuppressed(e);
        }
    }
}

