/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import javax.persistence.Entity;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.webpieces.ctx.api.Current;
import org.webpieces.plugin.hibernate.metrics.DatabaseMetric;

public class HibernateEntityMeterBinder
implements MeterBinder {
    private final SessionFactory sessionFactory;

    public HibernateEntityMeterBinder(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void bindTo(@NonNull MeterRegistry meterRegistry) {
        if (this.sessionFactory instanceof SessionFactoryImplementor) {
            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)((SessionFactoryImplementor)this.sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
            EntityEventListener eventListener = new EntityEventListener(meterRegistry);
            eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{eventListener});
            eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{eventListener});
            eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{eventListener});
            eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{eventListener});
        }
    }

    static class EntityEventListener
    implements PostLoadEventListener,
    PostDeleteEventListener,
    PostUpdateEventListener,
    PostInsertEventListener {
        private final MeterRegistry meterRegistry;

        EntityEventListener(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
        }

        private Tags getTags(String entityName) {
            try {
                String requestPath = Current.request().relativePath;
                if (requestPath == null || requestPath.isBlank()) {
                    requestPath = "unknown";
                }
                return Tags.of((String[])new String[]{"entity", entityName, "request", requestPath});
            }
            catch (NullPointerException ignore) {
                return null;
            }
        }

        private String getEntityName(Object entity) {
            String entityName = entity.getClass().getAnnotation(Entity.class).name();
            if (entityName.isBlank()) {
                entityName = entity.getClass().getSimpleName();
            }
            return entityName;
        }

        public void onPostLoad(PostLoadEvent event) {
            String entityName = this.getEntityName(event.getEntity());
            Tags tags = this.getTags(entityName);
            if (tags == null) {
                return;
            }
            Counter.builder((String)DatabaseMetric.DATABASE_ENTITY_LOADS.getDottedMetricName()).tags((Iterable)tags).description("Entity loads").register(this.meterRegistry).increment();
        }

        public void onPostDelete(PostDeleteEvent event) {
            String entityName = this.getEntityName(event.getEntity());
            Tags tags = this.getTags(entityName);
            if (tags == null) {
                return;
            }
            Counter.builder((String)DatabaseMetric.DATABASE_ENTITY_DELETES.getDottedMetricName()).tags((Iterable)tags).description("Entity deletes").register(this.meterRegistry).increment();
        }

        public void onPostUpdate(PostUpdateEvent event) {
            String entityName = this.getEntityName(event.getEntity());
            Tags tags = this.getTags(entityName);
            if (tags == null) {
                return;
            }
            Counter.builder((String)DatabaseMetric.DATABASE_ENTITY_UPDATES.getDottedMetricName()).tags((Iterable)tags).description("Entity updates").register(this.meterRegistry).increment();
        }

        public void onPostInsert(PostInsertEvent event) {
            String entityName = this.getEntityName(event.getEntity());
            Tags tags = this.getTags(entityName);
            if (tags == null) {
                return;
            }
            Counter.builder((String)DatabaseMetric.DATABASE_ENTITY_INSERTS.getDottedMetricName()).tags((Iterable)tags).description("Entity inserts").register(this.meterRegistry).increment();
        }

        public boolean requiresPostCommitHanding(EntityPersister persister) {
            return false;
        }
    }
}

