/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpproxy.impl;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.inject.Singleton;
import org.webpieces.data.api.BufferCreationPool;
import org.webpieces.data.api.BufferPool;
import org.webpieces.frontend.api.HttpFrontendFactory;
import org.webpieces.frontend.api.HttpFrontendManager;
import org.webpieces.httpclient.api.HttpClient;
import org.webpieces.httpclient.api.HttpClientFactory;
import org.webpieces.httpclient.api.HttpsSslEngineFactory;
import org.webpieces.httpproxy.api.HttpProxy;
import org.webpieces.httpproxy.api.ProxyConfig;
import org.webpieces.httpproxy.impl.ForTestSslClientEngineFactory;
import org.webpieces.httpproxy.impl.HttpProxyImpl;
import org.webpieces.util.threading.NamedThreadFactory;

public class HttpProxyModule
implements Module {
    private ProxyConfig config;

    public HttpProxyModule(ProxyConfig config) {
        this.config = config;
    }

    public void configure(Binder binder) {
        binder.bind(HttpProxy.class).to(HttpProxyImpl.class);
        binder.bind(ProxyConfig.class).toInstance((Object)this.config);
    }

    @Provides
    @Singleton
    public ScheduledExecutorService provideTimer() {
        return new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("webpieces-timer"));
    }

    @Provides
    @Singleton
    public HttpFrontendManager providesAsyncServerMgr(ProxyConfig config, ScheduledExecutorService timer) {
        BufferCreationPool pool = new BufferCreationPool();
        return HttpFrontendFactory.createFrontEnd((String)"httpFrontEnd", (int)config.getNumFrontendServerThreads(), (ScheduledExecutorService)timer, (BufferPool)pool);
    }

    @Provides
    @Singleton
    public HttpClient provideHttpClient(ProxyConfig config) {
        if (config.isForceAllConnectionToHttps()) {
            return HttpClientFactory.createHttpsClient((int)config.getNumHttpClientThreads(), (HttpsSslEngineFactory)new ForTestSslClientEngineFactory());
        }
        return HttpClientFactory.createHttpClient((int)config.getNumHttpClientThreads());
    }
}

