/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpproxy.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.frontend.api.FrontendConfig;
import org.webpieces.frontend.api.HttpFrontend;
import org.webpieces.frontend.api.HttpFrontendManager;
import org.webpieces.frontend.api.HttpRequestListener;
import org.webpieces.httpproxy.api.HttpProxy;
import org.webpieces.httpproxy.impl.chain.Layer4Processor;

public class HttpProxyImpl
implements HttpProxy {
    private static final Logger log = LoggerFactory.getLogger(HttpProxyImpl.class);
    @Inject
    private HttpFrontendManager serverMgr;
    @Inject
    private Layer4Processor serverListener;
    private HttpFrontend httpServer;

    @Override
    public void start() {
        log.info("starting server");
        InetSocketAddress addr = new InetSocketAddress(8080);
        FrontendConfig config = new FrontendConfig("httpProxy", (SocketAddress)addr);
        config.asyncServerConfig.functionToConfigureBeforeBind = s -> s.socket().setReuseAddress(true);
        this.httpServer = this.serverMgr.createHttpServer(config, (HttpRequestListener)this.serverListener);
        log.info("now listening for incoming connections");
    }

    @Override
    public void stop() {
        this.httpServer.close();
    }
}

