/*
 * Decompiled with CFR 0.152.
 */
package WEBPIECESxPACKAGE;

import WEBPIECESxPACKAGE.ProdServerForIDE;
import WEBPIECESxPACKAGE.Server;
import WEBPIECESxPACKAGE.ServerConfig;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.devrouter.api.DevRouterModule;
import org.webpieces.templatingdev.api.DevTemplateModule;
import org.webpieces.templatingdev.api.TemplateCompileConfig;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.file.VirtualFileImpl;

public class DevelopmentServer {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        try {
            String version = System.getProperty("java.version");
            log.info("Starting Development Server under java version=" + version);
            new DevelopmentServer(false).start();
            Class<DevelopmentServer> clazz = DevelopmentServer.class;
            synchronized (DevelopmentServer.class) {
                DevelopmentServer.class.wait();
                // ** MonitorExit[var2_3] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            log.error("Failed to startup.  exiting jvm. msg=" + e.getMessage(), e);
            System.exit(1);
        }
        {
            return;
        }
    }

    public DevelopmentServer(boolean usePortZero) {
        VirtualFileImpl directory = ProdServerForIDE.modifyForIDE();
        ArrayList<VirtualFile> srcPaths = new ArrayList<VirtualFile>();
        srcPaths.add(directory.child("WEBPIECESxAPPNAME/src/main/java"));
        srcPaths.add(directory.child("WEBPIECESxAPPNAME-dev/src/main/java"));
        VirtualFile metaFile = directory.child("WEBPIECESxAPPNAME/src/main/resources/appmetadev.txt");
        log.info("LOADING from meta file=" + metaFile.getCanonicalPath());
        TemplateCompileConfig templateConfig = new TemplateCompileConfig(srcPaths).setFileEncoding(Server.ALL_FILE_ENCODINGS);
        CompileConfig devConfig = new CompileConfig(srcPaths, CompileConfig.getTmpDir()).setFileEncoding(Server.ALL_FILE_ENCODINGS);
        Module platformOverrides = Modules.combine((Module[])new Module[]{new DevRouterModule(devConfig), new DevTemplateModule(templateConfig)});
        String[] args = usePortZero ? new String[]{"-http.port=:0", "-https.port=:0", "-hibernate.persistenceunit=hibernatefortest"} : new String[]{"-hibernate.persistenceunit=hibernatefortest"};
        ServerConfig config = new ServerConfig(false);
        config.setStaticFileCacheTimeSeconds(null);
        config.setMetaFile(metaFile);
        this.server = new Server(platformOverrides, null, config, args);
    }

    public void start() throws InterruptedException {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }
}

