/*
 * Decompiled with CFR 0.152.
 */
package webpiecesxxxxxpackage.services;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.devrouter.api.DevRouterModule;
import org.webpieces.templatingdev.api.DevTemplateModule;
import org.webpieces.templatingdev.api.TemplateCompileConfig;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.webserver.api.ServerConfig;
import webpiecesxxxxxpackage.basesvr.YourCompanyServer;
import webpiecesxxxxxpackage.meta.JavaCache;
import webpiecesxxxxxpackage.services.YourCompanyAbstractDevServer;

public abstract class YourCompanyDevelopmentServer
extends YourCompanyAbstractDevServer {
    private static final Logger log = LoggerFactory.getLogger(YourCompanyDevelopmentServer.class);
    private final YourCompanyServer server;

    public YourCompanyDevelopmentServer(String name, boolean usePortZero) {
        super(name, usePortZero);
        VirtualFile metaFile = this.directory.child(name + "/src/main/resources/appmetadev.txt");
        TemplateCompileConfig templateConfig = new TemplateCompileConfig((List)this.srcPaths);
        CompileConfig devConfig = new CompileConfig((List)this.srcPaths, JavaCache.getByteCache());
        devConfig.setFailIfNotInSourcePaths("WEBPIECESxPACKAGE");
        Module platformOverrides = Modules.combine((Module[])new Module[]{new DevRouterModule(devConfig), new DevTemplateModule(templateConfig)});
        ServerConfig config = new ServerConfig(false);
        config.setStaticFileCacheTimeSeconds(null);
        config.setMetaFile(metaFile);
        log.info("LOADING from meta file=" + config.getMetaFile().getCanonicalPath());
        this.server = this.createServer(platformOverrides, null, config, this.args);
    }

    protected abstract YourCompanyServer createServer(Module var1, Module var2, ServerConfig var3, String ... var4);

    @Override
    public final void start() {
        this.server.start();
    }

    public final void stop() {
        this.server.stop();
    }
}

