/*
 * Decompiled with CFR 0.152.
 */
package WEBPIECESxPACKAGE;

import WEBPIECESxPACKAGE.ServerConfig;
import WEBPIECESxPACKAGE.WEBPIECESxCLASSServer;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.devrouter.api.DevRouterModule;
import org.webpieces.templating.api.DevTemplateModule;
import org.webpieces.templating.api.TemplateCompileConfig;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.file.VirtualFileImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class WEBPIECESxCLASSDevServer {
    private static final Logger log = LoggerFactory.getLogger(WEBPIECESxCLASSServer.class);
    private WEBPIECESxCLASSServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        new WEBPIECESxCLASSDevServer(false).start();
        Class<WEBPIECESxCLASSDevServer> clazz = WEBPIECESxCLASSDevServer.class;
        synchronized (WEBPIECESxCLASSDevServer.class) {
            WEBPIECESxCLASSDevServer.class.wait();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public WEBPIECESxCLASSDevServer(boolean usePortZero) {
        String filePath1 = System.getProperty("user.dir");
        log.info("running from dir=" + filePath1);
        String directory = WEBPIECESxCLASSDevServer.modifyForIDE(filePath1);
        ArrayList<VirtualFileImpl> srcPaths = new ArrayList<VirtualFileImpl>();
        srcPaths.add(new VirtualFileImpl(directory + "/WEBPIECESxAPPNAME/src/main/java"));
        VirtualFileImpl metaFile = new VirtualFileImpl(directory + "/WEBPIECESxAPPNAME/src/main/resources/appmeta.txt");
        log.info("LOADING from meta file=" + metaFile.getCanonicalPath());
        TemplateCompileConfig templateConfig = new TemplateCompileConfig(srcPaths).setFileEncoding(WEBPIECESxCLASSServer.ALL_FILE_ENCODINGS);
        CompileConfig devConfig = new CompileConfig(srcPaths).setFileEncoding(WEBPIECESxCLASSServer.ALL_FILE_ENCODINGS);
        Module platformOverrides = Modules.combine((Module[])new Module[]{new DevRouterModule(devConfig), new DevTemplateModule(templateConfig)});
        ServerConfig config = new ServerConfig();
        if (usePortZero) {
            config.setHttpPort(0);
            config.setHttpsPort(0);
        } else {
            config.setHttpPort(9000);
            config.setHttpsPort(9443);
        }
        config.setStaticFileCacheTimeSeconds(null);
        config.setMetaFile((VirtualFile)metaFile);
        this.server = new WEBPIECESxCLASSServer(platformOverrides, null, config);
    }

    public static String modifyForIDE(String filePath1) {
        String directory = filePath1;
        if (filePath1.contains("WEBPIECESxAPPNAME-dev")) {
            directory = directory + "/..";
        } else if (filePath1.endsWith("webpieces")) {
            directory = directory + "/webserver/webpiecesServerBuilder/templateProject";
        }
        return directory;
    }

    public void start() throws InterruptedException {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }
}

