<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function diff

Create a new matrix or array of the difference between elements of the given array
The optional dim parameter lets you specify the dimension to evaluate the difference of
If no dimension parameter is passed it is assumed as dimension 0

Dimension is zero-based in javascript and one-based in the parser and can be a number or bignumber
Arrays must be 'rectangular' meaning arrays like [1, 2]
If something is passed as a matrix it will be returned as a matrix but other than that all matrices are converted to arrays


## Syntax

```js
math.diff(arr)
math.diff(arr, dim)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`arr` | Array &#124; Matrix | An array or matrix
`dim` | number | Dimension

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | Difference between array elements in given dimension


## Examples

```js
const arr = [1, 2, 4, 7, 0]
math.diff(arr) // returns [1, 2, 3, -7] (no dimension passed so 0 is assumed)
math.diff(math.matrix(arr)) // returns math.matrix([1, 2, 3, -7])

const arr = [[1, 2, 3, 4, 5], [1, 2, 3, 4, 5], [9, 8, 7, 6, 4]]
math.diff(arr) // returns [[0, 0, 0, 0, 0], [8, 6, 4, 2, -1]]
math.diff(arr, 0) // returns [[0, 0, 0, 0, 0], [8, 6, 4, 2, -1]]
math.diff(arr, 1) // returns [[1, 1, 1, 1], [1, 1, 1, 1], [-1, -1, -1, -2]]
math.diff(arr, math.bignumber(1)) // returns [[1, 1, 1, 1], [1, 1, 1, 1], [-1, -1, -1, -2]]

math.diff(arr, 2) // throws RangeError as arr is 2 dimensional not 3
math.diff(arr, -1) // throws RangeError as negative dimensions are not allowed

// These will all produce the same result
math.diff([[1, 2], [3, 4]])
math.diff([math.matrix([1, 2]), math.matrix([3, 4])])
math.diff([[1, 2], math.matrix([3, 4])])
math.diff([math.matrix([1, 2]), [3, 4]])
// They do not produce the same result as  math.diff(math.matrix([[1, 2], [3, 4]])) as this returns a matrix
```


## See also

[sum](sum.md),
[subtract](subtract.md),
[partitionSelect](partitionSelect.md)
