"use strict";
/**
 * formatter.js
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var encoder = __importStar(require("./encoder"));
var PemArmorString = {
    'public': 'PUBLIC KEY',
    'private': 'PRIVATE KEY',
    'encryptedPrivate': 'ENCRYPTED PRIVATE KEY',
    'certificate': 'CERTIFICATE',
    'certRequest': 'CERTIFICATE REQUEST'
};
/**
 * Convert PEM armored string to Uint8Array
 * @param keydataB64Pem
 * @return {Uint8Array}
 */
exports.pemToBin = function (keydataB64Pem) {
    var keydataB64 = dearmorPem(keydataB64Pem);
    return encoder.decodeBase64(keydataB64);
};
/**
 * Convert ArrayBuffer or TypedArray to PEM armored string with a specified type
 * @param keydata
 * @param type
 * @return {string}
 */
exports.binToPem = function (keydata, type) {
    var keydataB64 = encoder.encodeBase64(keydata);
    return formatAsPem(keydataB64, type);
};
/**
 * Armor the given Base64 string and return PEM formatted string
 * @param str
 * @param type
 * @return {string}
 */
var formatAsPem = function (str, type) {
    var typeString = PemArmorString[type];
    var finalString = "-----BEGIN " + typeString + "-----\n";
    while (str.length > 0) {
        finalString += str.substring(0, 64) + "\n";
        str = str.substring(64);
    }
    finalString = finalString + "-----END " + typeString + "-----";
    return finalString;
};
/**
 * Dearmor the given PEM string and return Base64 string
 * @param str
 * @return {string}
 */
var dearmorPem = function (str) {
    // const beginRegExp = RegExp('^-----[\s]*BEGIN[^-]*KEY-----$', 'gm');
    // const endRegExp = RegExp('^-----[\s]*END[^-]*KEY-----$', 'gm');
    var beginRegExp = RegExp('^-----[\s]*BEGIN[^-]*-----$', 'gm');
    var endRegExp = RegExp('^-----[\s]*END[^-]*-----$', 'gm');
    // check if the object starts from 'begin'
    try {
        var dearmored = str.split(beginRegExp)[1].split(endRegExp)[0];
        dearmored = dearmored.replace(/\r?\n/g, '');
        return dearmored;
    }
    catch (e) {
        throw new Error('Invalid format as PEM');
    }
};
//# sourceMappingURL=formatter.js.map