/**
 * formatter.js
 */
declare type SupportedPemTypes = 'public' | 'private' | 'encryptedPrivate' | 'certificate' | 'certRequest';
/**
 * Convert PEM armored string to Uint8Array
 * @param keydataB64Pem
 * @return {Uint8Array}
 */
export declare const pemToBin: (keydataB64Pem: string) => string | Uint8Array;
/**
 * Convert ArrayBuffer or TypedArray to PEM armored string with a specified type
 * @param keydata
 * @param type
 * @return {string}
 */
export declare const binToPem: (keydata: ArrayBuffer | Uint8Array | Uint8ClampedArray | Uint16Array | Uint32Array | Int8Array | Int16Array | Int32Array | Float32Array | Float64Array, type: SupportedPemTypes) => string;
export {};
