"use strict";
/**
 * encoder.js
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var env = __importStar(require("./env"));
/**
 * Encode ArrayBuffer or TypedArray To Base64
 * @param data
 * @return {*}
 */
exports.encodeBase64 = function (data) {
    var str = '';
    if (typeof data === 'string')
        str = data;
    else
        str = exports.arrayBufferToString(data);
    var btoa = env.getEnvBtoa();
    return btoa(str);
};
/**
 * Decode Base64 to Uint8Array
 * @param str
 * @return {Uint8Array|string|*}
 */
exports.decodeBase64 = function (str) {
    var atob = env.getEnvAtob();
    var binary = atob(str);
    var data = exports.stringToArrayBuffer(binary);
    return getAsciiIfAscii(data);
};
/**
 * if input data is an ArrayBuffer or TypedArray, it would be returned as Uint8Array
 * @param data
 * @return {Uint8Array}
 */
var sanitizeTypedArrayAndArrayBuffer = function (data) {
    if (data instanceof Uint8Array)
        return data;
    if (ArrayBuffer.isView(data) && typeof data.buffer !== 'undefined') { // TypedArray except Uint8Array
        return new Uint8Array(data.buffer);
    }
    else
        return new Uint8Array(data); // ArrayBuffer
};
/**
 * Check if the given Uint8Array can be expressed in Ascii Text
 * @param data
 * @return {Uint8Array|string|*}
 */
var getAsciiIfAscii = function (data) {
    var flag = true;
    for (var i = 0; i < data.length; i++) {
        if (data[i] > 0x7e || (data[i] < 0x20 && data[i] !== 0x0d && data[i] !== 0x0a)) {
            flag = false;
            break;
        }
    }
    var returnData = null;
    if (flag) {
        returnData = '';
        for (var i = 0; i < data.length; i++)
            returnData += String.fromCharCode(data[i]);
    }
    else
        returnData = data;
    return returnData;
};
/**
 * Encode ArrayBuffer or TypedArray to base64url string
 * @param data
 * @return {string}
 */
exports.encodeBase64Url = function (data) { return exports.encodeBase64(data).replace(/\+/g, '-').replace(/\//g, '_').replace(/=+$/, ''); };
/**
 * Decode Base64Url string to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
exports.decodeBase64Url = function (str) {
    str = str.replace(/-/g, '+').replace(/_/g, '/');
    // str = str + "=".repeat(str.length % 4); // this sometimes causes error...
    return exports.decodeBase64(str);
};
/**
 * Encode ArrayBuffer or TypedArray to hex string
 * @param data
 * @return {string}
 */
exports.arrayBufferToHexString = function (data) {
    var arr = sanitizeTypedArrayAndArrayBuffer(data);
    var hexStr = '';
    for (var i = 0; i < arr.length; i++) {
        var hex = (arr[i] & 0xff).toString(16);
        hex = (hex.length === 1) ? "0" + hex : hex;
        hexStr += hex;
    }
    return hexStr;
};
/**
 * Decode hex string to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
exports.hexStringToArrayBuffer = function (str) {
    var arr = [];
    var len = str.length;
    for (var i = 0; i < len; i += 2)
        arr.push(parseInt(str.substr(i, 2), 16));
    return new Uint8Array(arr);
};
/**
 * Encode ArrayBuffer or TypedArray to string with code (like output of legacy atob)
 * @param data
 * @return {string}
 */
exports.arrayBufferToString = function (data) {
    var bytes = sanitizeTypedArrayAndArrayBuffer(data);
    var arr = new Array(bytes.length);
    bytes.forEach(function (x, i) { arr[i] = x; });
    return String.fromCharCode.apply(null, arr);
};
/**
 * Decode string with code (like output of legacy atob) to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
exports.stringToArrayBuffer = function (str) {
    var bytes = new Uint8Array(str.length);
    return bytes.map(function (_x, i) { return str.charCodeAt(i); });
};
//# sourceMappingURL=encoder.js.map