import { jQuery } from "../core.js";

import "../ajax.js";

jQuery.ajaxPrefilter( function( s, origOptions ) {

	// Binary data needs to be passed to XHR as-is without stringification.
	if ( typeof s.data !== "string" && !jQuery.isPlainObject( s.data ) &&
			!Array.isArray( s.data ) &&

			// Don't disable data processing if explicitly set by the user.
			!( "processData" in origOptions ) ) {
		s.processData = false;
	}

	// `Content-Type` for requests with `FormData` bodies needs to be set
	// by the browser as it needs to append the `boundary` it generated.
	if ( s.data instanceof window.FormData ) {
		s.contentType = false;
	}
} );
