import { IHasher } from './WASMInterface';
import { IDataType } from './util';
/**
 * Calculates SHA-2 (SHA-512) hash
 * @param data Input data (string, Buffer or TypedArray)
 * @returns Computed hash as a hexadecimal string
 */
export declare function sha512(data: IDataType): Promise<string>;
/**
 * Creates a new SHA-2 (SHA-512) hash instance
 */
export declare function createSHA512(): Promise<IHasher>;
