<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## AssetManager

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 assetManager: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const assetManager = editor.AssetManager;
```

-   [add][2]
-   [get][3]
-   [getAll][4]
-   [getAllVisible][5]
-   [remove][6]
-   [store][7]
-   [load][8]
-   [getContainer][9]
-   [getAssetsEl][10]
-   [addType][11]
-   [getType][12]
-   [getTypes][13]

## add

Add new asset/s to the collection. URLs are supposed to be unique

### Parameters

-   `asset` **([string][14] \| [Object][15] \| [Array][16]&lt;[string][14]> | [Array][16]&lt;[Object][15]>)** URL strings or an objects representing the resource.
-   `opts` **[Object][15]?** Options (optional, default `{}`)

### Examples

```javascript
// In case of strings, would be interpreted as images
assetManager.add('http://img.jpg');
assetManager.add(['http://img.jpg', './path/to/img.png']);

// Using objects you could indicate the type and other meta informations
assetManager.add({
	src: 'http://img.jpg',
	//type: 'image',	//image is default
	height: 300,
width: 200,
});
assetManager.add([{
	src: 'http://img.jpg',
},{
	src: './path/to/img.png',
}]);
```

Returns **Model** 

## get

Returns the asset by URL

### Parameters

-   `src` **[string][14]** URL of the asset

### Examples

```javascript
var asset = assetManager.get('http://img.jpg');
```

Returns **[Object][15]** Object representing the asset

## getAll

Return the global collection, containing all the assets

Returns **Collection** 

## getAllVisible

Return the visible collection, which containes assets actually rendered

Returns **Collection** 

## remove

Remove the asset by its URL

### Parameters

-   `src` **[string][14]** URL of the asset

### Examples

```javascript
assetManager.remove('http://img.jpg');
```

Returns **this** 

## store

Store assets data to the selected storage

### Parameters

-   `noStore` **[Boolean][17]** If true, won't store

### Examples

```javascript
var assets = assetManager.store();
```

Returns **[Object][15]** Data to store

## load

Load data from the passed object.
The fetched data will be added to the collection.

### Parameters

-   `data` **[Object][15]** Object of data to load (optional, default `{}`)

### Examples

```javascript
var assets = assetManager.load({
	assets: [...]
})
```

Returns **[Object][15]** Loaded assets

## getContainer

Return the Asset Manager Container

Returns **[HTMLElement][18]** 

## getAssetsEl

Get assets element container

Returns **[HTMLElement][18]** 

## render

Render assets

### Parameters

-   `assets` **[array][16]** Assets to render, without the argument will render
                           all global assets

### Examples

```javascript
// Render all assets
assetManager.render();

// Render some of the assets
const assets = assetManager.getAll();
assetManager.render(assets.filter(
 asset => asset.get('category') == 'cats'
));
```

Returns **[HTMLElement][18]** 

## addType

Add new type. If you want to get more about type definition we suggest to read the [module's page][19]

### Parameters

-   `id` **[string][14]** Type ID
-   `definition` **[Object][15]** Definition of the type. Each definition contains
                               `model` (business logic), `view` (presentation logic)
                               and `isType` function which recognize the type of the
                               passed entity

### Examples

```javascript
assetManager.addType('my-type', {
 model: {},
 view: {},
 isType: (value) => {},
})
```

## getType

Get type

### Parameters

-   `id` **[string][14]** Type ID

Returns **[Object][15]** Type definition

## getTypes

Get types

Returns **[Array][16]** 

[1]: https://github.com/artf/grapesjs/blob/master/src/asset_manager/config/config.js

[2]: #add

[3]: #get

[4]: #getall

[5]: #getallvisible

[6]: #remove

[7]: #store

[8]: #load

[9]: #getcontainer

[10]: #getassetsel

[11]: #addtype

[12]: #gettype

[13]: #gettypes

[14]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[15]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[16]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[17]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[18]: https://developer.mozilla.org/docs/Web/HTML/Element

[19]: /modules/Assets.html
