'use strict';

const gulp = require('gulp');
const path = require('path');
const fs = require('fs-extra');
const { promisify } = require('util');
const exec = promisify(require('child_process').exec);

async function rebuild() {
  await fs.remove(path.join(__dirname, 'vaadin-usage-statistics-collect.html'));

  const template = await fs.readFile(
    path.join(__dirname, 'src/vaadin-usage-statistics.tpl.html'), 'utf-8');

  await exec('npm run transpile');
  const bundle = await fs.readFile(
    path.join(__dirname, 'vaadin-usage-statistics.es5.js'), 'utf-8');

  await fs.outputFile(
    path.join(__dirname, 'vaadin-usage-statistics-collect.html'),
    '<!-- This file is autogenerated from src/vaadin-usage-statistics.tpl.html -->\n' +
    template.replace('${vaadin-usage-statistics.js}', bundle));

  await fs.remove(path.join(__dirname, 'vaadin-usage-statistics.es5.js'));
}

// Check if any dependency of 'vaadin-usage-statistics.html' is staged for commit,
// and if yes, rebuild 'vaadin-usage-statistics.html' and add it to the commit
// as well.
gulp.task('auto-amend-commit', async () => {
  const deps = [
    'src/vaadin-usage-statistics.js',
    'src/vaadin-usage-statistics.tpl.html',
  ];

  const rc = await exec('git diff --name-only --cached');
  const depsStaged = rc.stdout.split('\n').some(file => deps.includes(file));
  if (depsStaged) {
    await rebuild();
    await exec('git add vaadin-usage-statistics-collect.html');
  }
});

gulp.task('rebuild', async () => {
  await rebuild();
});
