# Расширение параллакс

![](https://cloud.githubusercontent.com/assets/1706326/23580315/f28edab4-00f6-11e7-90f9-81ffafd77b0e.gif)

Прочтите раздел [Использование расширений](https://github.com/alvarotrigo/fullPage.js/tree/dev/lang/russian#%D0%98%D1%81%D0%BF%D0%BE%D0%BB%D1%8C%D0%B7%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D0%B5-%D1%80%D0%B0%D1%81%D1%88%D0%B8%D1%80%D0%B5%D0%BD%D0%B8%D0%B9) перед использованием опции параллакс.
- [Живое демо](http://alvarotrigo.com/fullPage/extensions/parallax.html)
- [Необходимая HTML-структура](#Необходимая-html-структура)
- [Добавление фона](#Добавление-фона)
- [Опции](#Опции)
  - [Эффекты параллакс](#Эффекты-параллакс)
- [Функции](#Функции)

## Необходимая HTML-структура
Чтобы использовать эффект параллакс в разделах и слайдах, необходимо добавить новый элемент с классом `fp-bg`. Это должен быть пустой `div`, который следует разместить как первый дочерний элемент раздела или слайда. Например:
```html
<div class="fp-bg"></div>
```

Это будет элемент, к которому вы должны будете добавить фон, вместо добавления его к разделу или слайдам, где он должен отобразиться.

Например:
```html
<div id="fullpage">
    <div class="section" id="section1">
        <div class="fp-bg"></div>
        Слайд 1.1
    </div>
    <div class="section" id="section2">
        <div class="slide" id="slide2-1">
            <div class="fp-bg"></div>
            Слайд 2.1
        </div>
        <div class="slide" id="slide2-2">
            <div class="fp-bg"></div>
            Слайд 2.2
        </div>
    </div>
</div>
```

Данную структуру можно увидеть в исходном коде [демо-страницы параллакс](http://alvarotrigo.com/fullPage/extensions/parallax.html).

> Если по какой-либо причине вы не желаете добавлять новый элемент в вашу разметку, вы можете установить опцию `property` в `parallaxOptions` для `background`, чтобы применить эффект к фону текущего раздела или слайда.
> Как объясняется в параграфе Эффекты параллакс, я рекомендую делать это только в случае крайней необходимости, так как воспроизведение будет не таким, как при использовании элементов `fp-bg`.

<br>

## Добавление фона
Фон должен добавляться к элементу `fp-bg` точно так же, как вы добавляли бы его к разделу или слайду.
Вы можете использовать CSS или встроенные стили.

Например:

```css
#section1 .fp-bg{
    background-image: url('imgs/alvaro-genious.jpg');
    background-size: cover;
    background-position: center 80%;
}
```
## Опции

| Опция  | Описание |
| ------------- | ------------- |
| **parallax**  | (по умолчанию: `false`). [Расширение fullPage.js](http://alvarotrigo.com/fullPage/extensions/). Определяет, будут ли использоваться эффекты параллакс для фона разделов / слайдов. |
| **parallaxOptions:**   | (по умолчанию: `{ type: 'reveal', percentage: 62, property: 'translate'}`). Позволяет изменять параметры эффекта параллакс для фона при использовании опции  `parallax:true`.  |
<br>

### Эффекты параллакс
Вы можете увидеть их в действии [на демо-странице](http://alvarotrigo.com/fullPage/extensions/parallax.html)

Описание изменяемых опций, доступных в `parallaxOptions`:

| parallaxOptions  | Описание |
| ------------- | ------------- |
| **type**  | (по умолчанию: `reveal`) Возможные значения `cover` и `reveal`. Обеспечивает возможность выбрать, будет ли текущий раздел/слайд отображаться выше или ниже заданного. При использовании `cover` следующий раздел или слайд появится, закрывая часть текущего. Использование `reveal` произведёт обратный эффект и закроет часть заданного при его отображении. |
| **percentage**  | (по умолчанию: 62 ) обеспечивает возможность определить процентное соотношение эффекта параллакс к окну просмотра. Меньшее значение даст меньший эффект параллакс, а значение 100, являющееся максимальным, даст полностью статичные фоны. |
| **property** | Определяет, применять ли эффект параллакс к элементу `fp-bg` или непосредственно к свойству фона раздела или слайда. Для этой опции рекомендуется использовать значение по умолчанию.
|

Обратите внимание, что использование элемента `fp-bg` обеспечивает лучшее воспроизведение, так как в этом случае используется аппаратное ускорение translate3d. Опция пригодится тем, кто по тем или иным причинам не желает добавлять элемент `fp-bg` в каждом разделе или слайде или просто не может изменить HTML-разметку.

## Функции
Вы можете увидеть их в действии [на демо-странице](http://alvarotrigo.com/fullPage/extensions/parallax.html)

### setOption(optionName, значение)
Устанавливает значение для данной опции. `optionName` может быть любой из опций, доступных в `parallaxOptions`. (`type`, `percentage` или `property`).
```javascript
//изменение значения для свойства `type`
$.fn.fullpage.parallax.setOption('type', 'cover');

//изменение значения для свойства `percentage`
$.fn.fullpage.parallax.setOption('percentage', '30');
```
---

### init()
Активирует эффект параллакс. Функция полезна, если вам необходимо активировать эффект в динамическом режиме в определённый момент.
```javascript
$.fn.fullpage.parallax.init();
```
---
### destroy()
Отключает эффект параллакс.
```javascript
$.fn.fullpage.parallax.destroy();
```
