/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.handler.AbstractResourceHandler;
import org.webbitserver.handler.FileEntry;
import org.webbitserver.handler.StaticFile;
import org.webbitserver.handler.TemplateEngine;
import org.webbitserver.helpers.ClassloaderResourceHelper;

public class StaticFileHandler
extends AbstractResourceHandler {
    private final File dir;
    private final long maxAge;

    public StaticFileHandler(File dir, Executor ioThread, TemplateEngine templateEngine) {
        super(ioThread, templateEngine);
        this.dir = dir;
        this.maxAge = 0L;
    }

    public StaticFileHandler(File dir, Executor ioThread) {
        this(dir, ioThread, (TemplateEngine)new StaticFile());
    }

    public StaticFileHandler(String dir, Executor ioThread, TemplateEngine templateEngine) {
        this(new File(dir), ioThread, templateEngine);
    }

    public StaticFileHandler(String dir, Executor ioThread) {
        this(dir, ioThread, (TemplateEngine)new StaticFile());
    }

    public StaticFileHandler(File dir, TemplateEngine templateEngine) {
        this(dir, (Executor)Executors.newFixedThreadPool(4), templateEngine);
    }

    public StaticFileHandler(File dir) {
        this(dir, (TemplateEngine)new StaticFile());
    }

    public StaticFileHandler(String dir, TemplateEngine templateEngine) {
        this(new File(dir), templateEngine);
    }

    public StaticFileHandler(String dir) {
        this(new File(dir));
    }

    public StaticFileHandler(File dir, Executor ioThread, TemplateEngine templateEngine, long maxAge) {
        super(ioThread, templateEngine);
        this.dir = dir;
        this.maxAge = maxAge;
    }

    public StaticFileHandler(File dir, Executor ioThread, long maxAge) {
        this(dir, ioThread, new StaticFile(), maxAge);
    }

    public StaticFileHandler(String dir, long maxAge) {
        this(new File(dir), maxAge);
    }

    public StaticFileHandler(File dir, long maxAge) {
        this(dir, Executors.newFixedThreadPool(4), new StaticFile(), maxAge);
    }

    @Override
    protected FileWorker createIOWorker(HttpRequest request, HttpResponse response, HttpControl control) {
        return new FileWorker(request, response, control, this.maxAge);
    }

    protected class FileWorker
    extends AbstractResourceHandler.IOWorker {
        private File file;
        private final HttpResponse response;
        private final HttpRequest request;
        private final long maxAge;

        private String mimeType(String uri) {
            String ext = uri.lastIndexOf(".") != -1 ? uri.substring(uri.lastIndexOf(".")) : null;
            String currentMimeType = (String)StaticFileHandler.this.mimeTypes.get(ext);
            if (currentMimeType == null) {
                currentMimeType = "text/plain";
            }
            return currentMimeType;
        }

        private String MD5(String md5) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] array = md.digest(md5.getBytes("UTF-8"));
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < array.length; ++i) {
                    sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
                }
                return sb.toString();
            }
            catch (Exception e) {
                return null;
            }
        }

        private String toHeader(Date date) {
            SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return httpDateFormat.format(date);
        }

        private Date fromHeader(String date) {
            SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                return httpDateFormat.parse(date);
            }
            catch (Exception ex) {
                return new Date();
            }
        }

        protected FileWorker(HttpRequest request, HttpResponse response, HttpControl control, long maxAge) {
            super(request.uri(), request, response, control);
            this.maxAge = maxAge;
            this.response = response;
            this.request = request;
        }

        @Override
        protected boolean exists() throws IOException {
            this.file = this.resolveFile(this.path);
            return this.file != null && this.file.exists();
        }

        @Override
        protected boolean isDirectory() throws IOException {
            return this.file.isDirectory();
        }

        @Override
        protected byte[] fileBytes() throws IOException {
            byte[] raw;
            byte[] byArray = raw = this.file.isFile() ? this.read(this.file) : null;
            if (raw != null) {
                Date lastModified = new Date(this.file.lastModified());
                String hashtext = this.MD5(Long.toString(lastModified.getTime()));
                if (hashtext != null) {
                    this.response.header("ETag", "\"" + hashtext + "\"");
                }
                this.response.header("Last-Modified", this.toHeader(lastModified));
                if (this.request.header("If-Modified-Since") != null && this.fromHeader(this.request.header("If-Modified-Since")).getTime() >= lastModified.getTime()) {
                    this.response.status(304);
                }
                if (this.maxAge != 0L) {
                    this.response.header("Expires", this.toHeader(new Date(new Date().getTime() + this.maxAge * 1000L)));
                    this.response.header("Cache-Control", "max-age=" + this.maxAge + ", public");
                }
            }
            return raw;
        }

        @Override
        protected byte[] welcomeBytes() throws IOException {
            File welcome = new File(this.file, StaticFileHandler.this.welcomeFileName);
            return welcome.isFile() ? this.read(welcome) : null;
        }

        @Override
        protected byte[] directoryListingBytes() throws IOException {
            if (!this.isDirectory()) {
                return null;
            }
            Iterable<FileEntry> files = ClassloaderResourceHelper.fileEntriesFor(this.file.listFiles());
            return StaticFileHandler.this.directoryListingFormatter.formatFileListAsHtml(files);
        }

        private byte[] read(File file) throws IOException {
            return this.read((int)file.length(), new FileInputStream(file));
        }

        protected File resolveFile(String path) throws IOException {
            File result = new File(StaticFileHandler.this.dir, path).getCanonicalFile();
            String fullPath = result.getPath();
            if (!fullPath.startsWith(StaticFileHandler.this.dir.getCanonicalPath() + File.separator) && !fullPath.equals(StaticFileHandler.this.dir.getCanonicalPath())) {
                return null;
            }
            return result;
        }
    }
}

