/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver;

import java.util.regex.Pattern;

public class EventSourceMessage {
    private static final Pattern START = Pattern.compile("^", 8);
    private static final String DATA = "data: ";
    private static final String COLON = ": ";
    private static final String ID = "id";
    private static final String EVENT = "event";
    private static final String RETRY = "retry";
    private static final String LF = "\n";
    private final StringBuilder payload = new StringBuilder();

    public EventSourceMessage() {
    }

    public EventSourceMessage(String data) {
        this();
        this.data(data);
    }

    public EventSourceMessage data(String data) {
        this.prependOnAllLines(DATA, data);
        return this;
    }

    public EventSourceMessage comment(String data) {
        this.prependOnAllLines(COLON, data);
        return this;
    }

    public EventSourceMessage id(long id) {
        return this.id(String.valueOf(id));
    }

    public EventSourceMessage id(String id) {
        this.appendFieldValue(ID, id);
        return this;
    }

    public EventSourceMessage event(String event) {
        this.appendFieldValue(EVENT, event);
        return this;
    }

    public EventSourceMessage retry(Long reconnectionTimeMillis) {
        this.appendFieldValue(RETRY, reconnectionTimeMillis.toString());
        return this;
    }

    public String build() {
        return this.payload.toString() + LF;
    }

    private void appendFieldValue(String field, String value) {
        this.payload.append(field);
        if (value != null && !value.isEmpty()) {
            this.payload.append(COLON);
            this.payload.append(value);
        }
        this.payload.append(LF);
    }

    private void prependOnAllLines(String field, String value) {
        String multilineField = START.matcher(value).replaceAll(field);
        this.payload.append(multilineField).append(LF);
    }
}

