/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3j.crypto.AccessListObject;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.Transaction2930;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;

public class Transaction1559
extends Transaction2930
implements ITransaction {
    private BigInteger maxPriorityFeePerGas;
    private BigInteger maxFeePerGas;

    public Transaction1559(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas) {
        super(chainId, nonce, null, gasLimit, to, value, data, Collections.emptyList());
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.maxFeePerGas = maxFeePerGas;
    }

    public Transaction1559(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, List<AccessListObject> accessList) {
        super(chainId, nonce, null, gasLimit, to, value, data, accessList);
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.maxFeePerGas = maxFeePerGas;
    }

    @Override
    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((long)this.getChainId()));
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getMaxPriorityFeePerGas()));
        result.add((RlpType)RlpString.create((BigInteger)this.getMaxFeePerGas()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        result.add((RlpType)new RlpList(this.rlpAccessListRlp()));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((long)Sign.getRecId(signatureData, this.getChainId())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        return result;
    }

    public static Transaction1559 createEtherTransaction(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas) {
        return new Transaction1559(chainId, nonce, gasLimit, to, value, "", maxPriorityFeePerGas, maxFeePerGas, Collections.emptyList());
    }

    public static Transaction1559 createTransaction(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, List<AccessListObject> accessList) {
        return new Transaction1559(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas, accessList);
    }

    public static Transaction1559 createTransaction(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas) {
        return new Transaction1559(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas);
    }

    @Override
    public TransactionType getType() {
        return TransactionType.EIP1559;
    }

    @Override
    public BigInteger getGasPrice() {
        throw new UnsupportedOperationException("not available for 1559 transaction");
    }

    public BigInteger getMaxPriorityFeePerGas() {
        return this.maxPriorityFeePerGas;
    }

    public BigInteger getMaxFeePerGas() {
        return this.maxFeePerGas;
    }
}

