/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.filters.Callback;
import org.web3j.protocol.core.filters.FilterException;
import org.web3j.protocol.core.methods.response.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.EthUninstallFilter;

public abstract class Filter<T> {
    private static final Logger log = LoggerFactory.getLogger(Filter.class);
    protected final Web3j web3j;
    protected Callback<T> callback;
    private volatile BigInteger filterId;
    protected ScheduledFuture<?> schedule;
    private ScheduledExecutorService scheduledExecutorService;
    private long blockTime;

    public Filter(Web3j web3j, Callback<T> callback) {
        this.web3j = web3j;
        this.callback = callback;
    }

    public void run(ScheduledExecutorService scheduledExecutorService, long blockTime) {
        try {
            EthFilter ethFilter = this.sendRequest();
            if (ethFilter.hasError()) {
                this.throwException(ethFilter.getError());
            }
            this.filterId = ethFilter.getFilterId();
            this.scheduledExecutorService = scheduledExecutorService;
            this.blockTime = blockTime;
            this.getInitialFilterLogs();
            this.schedule = scheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    this.pollFilter(ethFilter);
                }
                catch (Throwable e) {
                    log.error("Error sending request", e);
                }
            }, 0L, blockTime, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void getInitialFilterLogs() {
        try {
            Optional<Request<?, EthLog>> maybeRequest = this.getFilterLogs(this.filterId);
            EthLog ethLog = null;
            if (maybeRequest.isPresent()) {
                ethLog = maybeRequest.get().send();
            } else {
                ethLog = new EthLog();
                ethLog.setResult(Collections.emptyList());
            }
            if (ethLog.hasError()) {
                this.throwException(ethLog.getError());
            }
            this.process(ethLog.getLogs());
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void pollFilter(EthFilter ethFilter) {
        Response ethLog = null;
        try {
            ethLog = this.web3j.ethGetFilterChanges(this.filterId).send();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        if (ethLog.hasError()) {
            Response.Error error = ethLog.getError();
            switch (error.getCode()) {
                case -32000: {
                    this.reinstallFilter();
                    break;
                }
                default: {
                    this.throwException(error);
                    break;
                }
            }
        } else {
            this.process(((EthLog)ethLog).getLogs());
        }
    }

    protected abstract EthFilter sendRequest() throws IOException;

    protected abstract void process(List<EthLog.LogResult> var1);

    private void reinstallFilter() {
        log.warn("The filter has not been found. Filter id: " + this.filterId);
        this.schedule.cancel(false);
        this.run(this.scheduledExecutorService, this.blockTime);
    }

    public void cancel() {
        this.schedule.cancel(false);
        try {
            EthUninstallFilter ethUninstallFilter = this.uninstallFilter(this.filterId);
            if (ethUninstallFilter.hasError()) {
                this.throwException(ethUninstallFilter.getError());
            }
            if (!ethUninstallFilter.isUninstalled()) {
                throw new FilterException("Filter with id '" + this.filterId + "' failed to uninstall");
            }
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    protected EthUninstallFilter uninstallFilter(BigInteger filterId) throws IOException {
        return this.web3j.ethUninstallFilter(filterId).send();
    }

    protected abstract Optional<Request<?, EthLog>> getFilterLogs(BigInteger var1);

    void throwException(Response.Error error) {
        throw new FilterException("Invalid request: " + (error == null ? "Unknown Error" : error.getMessage()));
    }

    void throwException(Throwable cause) {
        throw new FilterException("Error sending request", cause);
    }
}

