/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.web3j.crypto.Bip39Wallet;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.MnemonicUtils;
import org.web3j.crypto.SecureRandomUtils;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.crypto.exception.CipherException;
import org.web3j.utils.Numeric;

public class WalletUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final SecureRandom secureRandom = SecureRandomUtils.secureRandom();

    public static String generateFullNewWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return WalletUtils.generateNewWalletFile(password, destinationDirectory, true);
    }

    public static String generateLightNewWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return WalletUtils.generateNewWalletFile(password, destinationDirectory, false);
    }

    public static String generateNewWalletFile(String password, File destinationDirectory) throws CipherException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        return WalletUtils.generateFullNewWalletFile(password, destinationDirectory);
    }

    public static String generateNewWalletFile(String password, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        return WalletUtils.generateWalletFile(password, ecKeyPair, destinationDirectory, useFullScrypt);
    }

    public static String generateWalletFile(String password, ECKeyPair ecKeyPair, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException {
        WalletFile walletFile = useFullScrypt ? Wallet.createStandard(password, ecKeyPair) : Wallet.createLight(password, ecKeyPair);
        String fileName = WalletUtils.getWalletFileName(walletFile);
        File destination = new File(destinationDirectory, fileName);
        objectMapper.writeValue(destination, (Object)walletFile);
        return fileName;
    }

    public static Bip39Wallet generateBip39Wallet(String password, File destinationDirectory) throws CipherException, IOException {
        byte[] initialEntropy = new byte[16];
        secureRandom.nextBytes(initialEntropy);
        String mnemonic = MnemonicUtils.generateMnemonic((byte[])initialEntropy);
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, (String)password);
        ECKeyPair privateKey = ECKeyPair.create((byte[])Hash.sha256((byte[])seed));
        String walletFile = WalletUtils.generateWalletFile(password, privateKey, destinationDirectory, false);
        return new Bip39Wallet(walletFile, mnemonic);
    }

    public static Bip39Wallet generateBip39WalletFromMnemonic(String password, String mnemonic, File destinationDirectory) throws CipherException, IOException {
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, (String)password);
        ECKeyPair privateKey = ECKeyPair.create((byte[])Hash.sha256((byte[])seed));
        String walletFile = WalletUtils.generateWalletFile(password, privateKey, destinationDirectory, false);
        return new Bip39Wallet(walletFile, mnemonic);
    }

    public static Credentials loadCredentials(String password, String source) throws IOException, CipherException {
        return WalletUtils.loadCredentials(password, new File(source));
    }

    public static Credentials loadCredentials(String password, File source) throws IOException, CipherException {
        WalletFile walletFile = (WalletFile)objectMapper.readValue(source, WalletFile.class);
        return Credentials.create((ECKeyPair)Wallet.decrypt(password, walletFile));
    }

    public static Credentials loadBip39Credentials(String password, String mnemonic) {
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, (String)password);
        return Credentials.create((ECKeyPair)ECKeyPair.create((byte[])Hash.sha256((byte[])seed)));
    }

    public static Credentials loadJsonCredentials(String password, String content) throws IOException, CipherException {
        WalletFile walletFile = (WalletFile)objectMapper.readValue(content, WalletFile.class);
        return Credentials.create((ECKeyPair)Wallet.decrypt(password, walletFile));
    }

    private static String getWalletFileName(WalletFile walletFile) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("'UTC--'yyyy-MM-dd'T'HH-mm-ss.nVV'--'");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return now.format(format) + walletFile.getAddress() + ".json";
    }

    public static String getDefaultKeyDirectory() {
        return WalletUtils.getDefaultKeyDirectory(System.getProperty("os.name"));
    }

    static String getDefaultKeyDirectory(String osName1) {
        String osName = osName1.toLowerCase();
        if (osName.startsWith("mac")) {
            return String.format("%s%sLibrary%sEthereum", System.getProperty("user.home"), File.separator, File.separator);
        }
        if (osName.startsWith("win")) {
            return String.format("%s%sEthereum", System.getenv("APPDATA"), File.separator);
        }
        return String.format("%s%s.ethereum", System.getProperty("user.home"), File.separator);
    }

    public static String getTestnetKeyDirectory() {
        return String.format("%s%stestnet%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator, File.separator);
    }

    public static String getMainnetKeyDirectory() {
        return String.format("%s%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator);
    }

    public static String getRinkebyKeyDirectory() {
        return String.format("%s%srinkeby%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator, File.separator);
    }

    public static boolean isValidPrivateKey(String privateKey) {
        String cleanPrivateKey = Numeric.cleanHexPrefix((String)privateKey);
        return cleanPrivateKey.length() == 64;
    }

    public static boolean isValidAddress(String input) {
        return WalletUtils.isValidAddress(input, 40);
    }

    public static boolean isValidAddress(String input, int addressLength) {
        String cleanInput = Numeric.cleanHexPrefix((String)input);
        try {
            Numeric.toBigIntNoPrefix((String)cleanInput);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return cleanInput.length() == addressLength;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

