/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;

public class RawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    final Credentials credentials;
    private final byte chainId;

    public RawTransactionManager(Web3j web3j, Credentials credentials, byte chainId) {
        super(web3j, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, byte chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, byte chainId, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress());
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials) {
        this(web3j, credentials, -1);
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, int attempts, int sleepDuration) {
        this(web3j, credentials, -1, attempts, sleepDuration);
    }

    protected BigInteger getNonce() throws IOException {
        EthGetTransactionCount ethGetTransactionCount = this.web3j.ethGetTransactionCount(this.credentials.getAddress(), DefaultBlockParameterName.PENDING).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    @Override
    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data);
        return this.signAndSend(rawTransaction);
    }

    public EthSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        byte[] signedMessage = this.chainId > -1 ? TransactionEncoder.signMessage((RawTransaction)rawTransaction, (byte)this.chainId, (Credentials)this.credentials) : TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)this.credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        return this.web3j.ethSendRawTransaction(hexValue).send();
    }
}

