/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.ManagedTransaction;
import org.web3j.tx.RawTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.ContractCallException;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.utils.Numeric;

public abstract class Contract
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(4300000L);
    public static final String FUNC_DEPLOY = "deploy";
    protected final String contractBinary;
    protected String contractAddress;
    protected ContractGasProvider gasProvider;
    protected TransactionReceipt transactionReceipt;
    protected Map<String, String> deployedAddresses;
    protected DefaultBlockParameter defaultBlockParameter = DefaultBlockParameterName.LATEST;

    protected Contract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider gasProvider) {
        super(web3j, transactionManager);
        this.contractAddress = this.ensResolver.resolve(contractAddress);
        this.contractBinary = contractBinary;
        this.gasProvider = gasProvider;
    }

    @Deprecated
    protected Contract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        this(contractBinary, contractAddress, web3j, transactionManager, new StaticGasProvider(gasPrice, gasLimit));
    }

    @Deprecated
    protected Contract(String contractBinary, String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this(contractBinary, contractAddress, web3j, new RawTransactionManager(web3j, credentials), gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, web3j, new RawTransactionManager(web3j, credentials), gasPrice, gasLimit);
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void setGasProvider(ContractGasProvider gasProvider) {
        this.gasProvider = gasProvider;
    }

    public void setGasPrice(BigInteger newPrice) {
        this.gasProvider = new StaticGasProvider(newPrice, this.gasProvider.getGasLimit());
    }

    public BigInteger getGasPrice() {
        return this.gasProvider.getGasPrice();
    }

    public boolean isValid() throws IOException {
        if (this.contractAddress.equals("")) {
            throw new UnsupportedOperationException("Contract binary not present, you will need to regenerate your smart contract wrapper with web3j v2.2.0+");
        }
        EthGetCode ethGetCode = this.web3j.ethGetCode(this.contractAddress, DefaultBlockParameterName.LATEST).send();
        if (ethGetCode.hasError()) {
            return false;
        }
        String code = Numeric.cleanHexPrefix((String)ethGetCode.getCode());
        return !code.isEmpty() && this.contractBinary.contains(code);
    }

    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    public void setDefaultBlockParameter(DefaultBlockParameter defaultBlockParameter) {
        this.defaultBlockParameter = defaultBlockParameter;
    }

    private List<Type> executeCall(Function function) throws IOException {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        EthCall ethCall = this.web3j.ethCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, encodedFunction), this.defaultBlockParameter).send();
        String value = ethCall.getValue();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws IOException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws IOException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws IOException {
        return this.executeCall(function);
    }

    protected TransactionReceipt executeTransaction(Function function) throws IOException, TransactionException {
        return this.executeTransaction(function, BigInteger.ZERO);
    }

    private TransactionReceipt executeTransaction(Function function, BigInteger weiValue) throws IOException, TransactionException {
        return this.executeTransaction(FunctionEncoder.encode((Function)function), weiValue, function.getName());
    }

    TransactionReceipt executeTransaction(String data, BigInteger weiValue, String funcName) throws TransactionException, IOException {
        TransactionReceipt receipt = this.send(this.contractAddress, data, weiValue, this.gasProvider.getGasPrice(funcName), this.gasProvider.getGasLimit(funcName));
        if (!receipt.isStatusOK()) {
            throw new TransactionException(String.format("Transaction has failed with status: %s. Gas used: %d. (not-enough gas?)", receipt.getStatus(), receipt.getGasUsed()));
        }
        return receipt;
    }

    protected <T extends Type> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function) {
        return new RemoteCall<Type>(() -> this.executeCallSingleValueReturn(function));
    }

    protected <T> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<Object>(() -> this.executeCallSingleValueReturn(function, returnType));
    }

    protected RemoteCall<List<Type>> executeRemoteCallMultipleValueReturn(Function function) {
        return new RemoteCall<List<Type>>(() -> this.executeCallMultipleValueReturn(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function, BigInteger weiValue) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function, weiValue));
    }

    private static <T extends Contract> T create(T contract, String binary, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        TransactionReceipt transactionReceipt = contract.executeTransaction(binary + encodedConstructor, value, FUNC_DEPLOY);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, Credentials.class, BigInteger.class, BigInteger.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, credentials, gasPrice, gasLimit);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> T deploy(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, TransactionManager.class, BigInteger.class, BigInteger.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, web3j, transactionManager, gasPrice, gasLimit);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, credentials, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, web3j, credentials, gasPrice, gasLimit, binary, encodedConstructor, BigInteger.ZERO);
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, BigInteger value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, web3j, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    public static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, web3j, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, BigInteger.ZERO);
    }

    public static EventValues staticExtractEventParameters(Event event, Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode((Event)event);
        if (!topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected EventValues extractEventParameters(Event event, Log log) {
        return Contract.staticExtractEventParameters(event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParameters(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected EventValuesWithLog extractEventParametersWithLog(Event event, Log log) {
        EventValues eventValues = Contract.staticExtractEventParameters(event, log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    protected List<EventValuesWithLog> extractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParametersWithLog(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String getStaticDeployedAddress(String networkId) {
        return null;
    }

    public final void setDeployedAddress(String networkId, String address) {
        if (this.deployedAddresses == null) {
            this.deployedAddresses = new HashMap<String, String>();
        }
        this.deployedAddresses.put(networkId, address);
    }

    public final String getDeployedAddress(String networkId) {
        String addr = null;
        if (this.deployedAddresses != null) {
            addr = this.deployedAddresses.get(networkId);
        }
        return addr == null ? this.getStaticDeployedAddress(networkId) : addr;
    }

    protected static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList<Object> out = new ArrayList<Object>();
        Iterator<S> it = arr.iterator();
        while (it.hasNext()) {
            out.add(((Type)it.next()).getValue());
        }
        return out;
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final Log log;

        private EventValuesWithLog(EventValues eventValues, Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public Log getLog() {
            return this.log;
        }
    }
}

