/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen.kotlin;

import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeAll;
import org.web3j.codegen.unit.gen.kotlin.FunSpecGenerator;
import org.web3j.codegen.unit.gen.kotlin.KotlinParser;
import org.web3j.codegen.unit.gen.utils.KotlinMappingHelper;
import org.web3j.codegen.unit.gen.utils.NameUtils;
import org.web3j.protocol.Web3j;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class FunParser {
    private final Method method;
    private final Class theContract;

    public FunParser(Method method, Class theContract) {
        this.method = method;
        this.theContract = theContract;
    }

    public FunSpec getFunSpec() {
        return this.methodNeedsInjection() ? new FunSpecGenerator(this.method.getName(), BeforeAll.class, this.defaultParameterSpecsForEachUnitTest(), this.generateStatementBody()).generate() : new FunSpecGenerator(this.method.getName(), this.generateStatementBody()).generate();
    }

    private boolean methodNeedsInjection() {
        return Arrays.asList(this.method.getParameterTypes()).containsAll(Arrays.asList(Web3j.class, TransactionManager.class, ContractGasProvider.class));
    }

    private List<ParameterSpec> defaultParameterSpecsForEachUnitTest() {
        return Stream.of(ParameterSpec.builder((String)NameUtils.toCamelCase(Web3j.class), Web3j.class, (KModifier[])new KModifier[0]).build(), ParameterSpec.builder((String)NameUtils.toCamelCase(TransactionManager.class), TransactionManager.class, (KModifier[])new KModifier[0]).build(), ParameterSpec.builder((String)NameUtils.toCamelCase(ContractGasProvider.class), ContractGasProvider.class, (KModifier[])new KModifier[0]).build()).collect(Collectors.toList());
    }

    private Map<String, Object[]> generateStatementBody() {
        LinkedHashMap<String, Object[]> methodBodySpecification = new LinkedHashMap<String, Object[]>();
        KotlinParser parser = new KotlinParser(this.theContract, this.method, new KotlinMappingHelper());
        String kotlinPoetStringTypes = parser.generatePoetStringTypes();
        Object[] genericParameters = parser.adjustPlaceholderValues();
        methodBodySpecification.put(kotlinPoetStringTypes, genericParameters);
        if (this.methodNeedsAssertion()) {
            String assertionKotlinPoet = parser.generateAssertionKotlinPoetStringTypes();
            Object[] assertionParams = parser.generateAssertionPlaceholderValues();
            methodBodySpecification.put(assertionKotlinPoet, assertionParams);
        }
        return methodBodySpecification;
    }

    private boolean methodNeedsAssertion() {
        return !this.methodNeedsInjection();
    }
}

