/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.web3j.abi.DefaultFunctionEncoder;
import org.web3j.abi.TypeDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.spi.FunctionEncoderProvider;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public abstract class FunctionEncoder {
    private static final FunctionEncoder FUNCTION_ENCODER;

    public static String encode(Function function) {
        return FUNCTION_ENCODER.encodeFunction(function);
    }

    public static String encode(String methodId, List<Type> parameters) {
        return FUNCTION_ENCODER.encodeWithSelector(methodId, parameters);
    }

    public static String encodeConstructor(List<Type> parameters) {
        return FUNCTION_ENCODER.encodeParameters(parameters);
    }

    public static String encodeConstructorPacked(List<Type> parameters) {
        return FUNCTION_ENCODER.encodePackedParameters(parameters);
    }

    public static Function makeFunction(String fnName, List<String> solidityInputTypes, List<Object> arguments, List<String> solidityOutputTypes) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Type> encodedInput = new ArrayList<Type>();
        Iterator<Object> argit = arguments.iterator();
        for (String st : solidityInputTypes) {
            encodedInput.add(TypeDecoder.instantiateType(st, argit.next()));
        }
        ArrayList encodedOutput = new ArrayList();
        for (String st : solidityOutputTypes) {
            encodedOutput.add(TypeReference.makeTypeReference(st));
        }
        return new Function(fnName, encodedInput, encodedOutput);
    }

    protected abstract String encodeFunction(Function var1);

    protected abstract String encodeParameters(List<Type> var1);

    protected abstract String encodeWithSelector(String var1, List<Type> var2);

    protected abstract String encodePackedParameters(List<Type> var1);

    protected static String buildMethodSignature(String methodName, List<Type> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(Type::getTypeAsString).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    protected static String buildMethodId(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash).substring(0, 10);
    }

    static {
        ServiceLoader<FunctionEncoderProvider> loader = ServiceLoader.load(FunctionEncoderProvider.class);
        Iterator<FunctionEncoderProvider> iterator = loader.iterator();
        FUNCTION_ENCODER = iterator.hasNext() ? (FunctionEncoder)iterator.next().get() : new DefaultFunctionEncoder();
    }
}

