/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.HashMap;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColorConstants;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.RGBATSC;

public class ATSCColor
extends CssValue
implements CssColorConstants,
CssOperator {
    Object color;
    RGBATSC rgb;
    static HashMap<String, Object> definedColorsATSC;
    static CssIdent inherit;

    public ATSCColor() {
        this.color = inherit;
    }

    public ATSCColor(ApplContext ac, String s) throws InvalidParamException {
        this.setIdentColor(s, ac);
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        if (s.startsWith("#")) {
            this.setShortRGBColor(s.toLowerCase(), ac);
        } else {
            this.setIdentColor(s, ac);
        }
    }

    public Object get() {
        if (this.color != null) {
            if (this.color == inherit) {
                return null;
            }
            return this.color;
        }
        return this.rgb.r;
    }

    public boolean isDefault() {
        return this.color == inherit;
    }

    public String toString() {
        if (this.color != null) {
            if (this.color == inherit) {
                return inherit.toString();
            }
            return this.color.toString();
        }
        return this.rgb.toString();
    }

    public void setRGBColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGBATSC();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            this.rgb.r = (Float)val.get();
        } else if (val instanceof CssPercentage) {
            this.rgb.r = (Float)val.get();
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            this.rgb.g = (Float)val.get();
        } else if (val instanceof CssPercentage) {
            this.rgb.g = (Float)val.get();
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            this.rgb.b = (Float)val.get();
        } else if (val instanceof CssPercentage) {
            this.rgb.b = (Float)val.get();
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    public void setATSCrgba(CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGBATSC();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            this.rgb.r = (Float)val.get();
        } else if (val instanceof CssPercentage) {
            this.rgb.r = (Float)val.get();
        } else {
            throw new InvalidParamException("ATSCrgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            this.rgb.g = (Float)val.get();
        } else if (val instanceof CssPercentage) {
            this.rgb.g = (Float)val.get();
        } else {
            throw new InvalidParamException("ATSCrgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            this.rgb.b = (Float)val.get();
        } else if (val instanceof CssPercentage) {
            this.rgb.b = (Float)val.get();
        } else {
            throw new InvalidParamException("ATSCrgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            this.rgb.o = (Float)val.get();
        } else if (val instanceof CssPercentage) {
            this.rgb.o = (Float)val.get();
        } else {
            throw new InvalidParamException("ATSCrgb", val, ac);
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("ATSCrgb", exp.getValue(), ac);
        }
    }

    private void setShortRGBColor(String s, ApplContext ac) throws InvalidParamException {
        int b;
        int g;
        int r;
        this.rgb = new RGBATSC();
        this.color = null;
        if ((s = s.substring(1)).length() != 3 && s.length() != 6) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (s.length() == 3) {
            String sh = s.substring(0, 1);
            r = Integer.parseInt(sh + sh, 16);
            sh = s.substring(1, 2);
            g = Integer.parseInt(sh + sh, 16);
            sh = s.substring(2, 3);
            b = Integer.parseInt(sh + sh, 16);
        } else {
            r = Integer.parseInt(s.substring(0, 2), 16);
            g = Integer.parseInt(s.substring(2, 4), 16);
            b = Integer.parseInt(s.substring(4, 6), 16);
        }
        this.rgb.r = new Integer(r);
        this.rgb.g = new Integer(g);
        this.rgb.b = new Integer(b);
        this.rgb.output = "#" + s;
    }

    private void setIdentColor(String s, ApplContext ac) throws InvalidParamException {
        String lower_s = s.toLowerCase();
        Object obj = definedColorsATSC.get(lower_s);
        if (obj != null) {
            if (obj instanceof RGBATSC) {
                this.color = lower_s;
                this.rgb = (RGBATSC)obj;
            } else if (obj instanceof String) {
                this.color = (String)obj;
            }
            return;
        }
        throw new InvalidParamException("value", s, "color", ac);
    }

    public boolean equals(Object cssColor) {
        return cssColor instanceof ATSCColor && (this.color != null && this.color.equals(((ATSCColor)cssColor).color) || this.color == null && this.rgb != null && ((ATSCColor)cssColor).rgb != null && this.rgb.r.equals(((ATSCColor)cssColor).rgb.r) && this.rgb.g.equals(((ATSCColor)cssColor).rgb.g) && this.rgb.b.equals(((ATSCColor)cssColor).rgb.b));
    }

    public Object getRed() {
        return this.rgb.r;
    }

    public Object getGreen() {
        return this.rgb.g;
    }

    public Object getBlue() {
        return this.rgb.b;
    }

    static {
        inherit = new CssIdent("inherit");
        definedColorsATSC = new HashMap();
        definedColorsATSC.put("black", new RGBATSC(new Integer(0), new Integer(0), new Integer(0), new Integer(255)));
        definedColorsATSC.put("silver", new RGBATSC(new Integer(192), new Integer(192), new Integer(192), new Integer(255)));
        definedColorsATSC.put("gray", new RGBATSC(new Integer(128), new Integer(128), new Integer(128), new Integer(255)));
        definedColorsATSC.put("white", new RGBATSC(new Integer(255), new Integer(255), new Integer(255), new Integer(255)));
        definedColorsATSC.put("maroon", new RGBATSC(new Integer(128), new Integer(0), new Integer(0), new Integer(255)));
        definedColorsATSC.put("red", new RGBATSC(new Integer(255), new Integer(0), new Integer(0), new Integer(255)));
        definedColorsATSC.put("purple", new RGBATSC(new Integer(128), new Integer(0), new Integer(128), new Integer(255)));
        definedColorsATSC.put("fuchsia", new RGBATSC(new Integer(255), new Integer(0), new Integer(255), new Integer(255)));
        definedColorsATSC.put("green", new RGBATSC(new Integer(0), new Integer(128), new Integer(0), new Integer(255)));
        definedColorsATSC.put("lime", new RGBATSC(new Integer(0), new Integer(255), new Integer(0), new Integer(255)));
        definedColorsATSC.put("olive", new RGBATSC(new Integer(128), new Integer(128), new Integer(0), new Integer(255)));
        definedColorsATSC.put("yellow", new RGBATSC(new Integer(255), new Integer(255), new Integer(0), new Integer(255)));
        definedColorsATSC.put("navy", new RGBATSC(new Integer(0), new Integer(0), new Integer(128), new Integer(255)));
        definedColorsATSC.put("blue", new RGBATSC(new Integer(0), new Integer(0), new Integer(255), new Integer(255)));
        definedColorsATSC.put("teal", new RGBATSC(new Integer(0), new Integer(128), new Integer(128), new Integer(255)));
        definedColorsATSC.put("aqua", new RGBATSC(new Integer(0), new Integer(255), new Integer(255), new Integer(255)));
        definedColorsATSC.put("activeborder", "ActiveBorder");
        definedColorsATSC.put("activecaption", "ActiveCaption");
        definedColorsATSC.put("appworkspace", "AppWorkspace");
        definedColorsATSC.put("background", "Background");
        definedColorsATSC.put("buttonface", "ButtonFace");
        definedColorsATSC.put("buttonhighlight", "ButtonHighlight");
        definedColorsATSC.put("buttonshadow", "ButtonShadow");
        definedColorsATSC.put("buttontext", "ButtonText");
        definedColorsATSC.put("captiontext", "CaptionText");
        definedColorsATSC.put("graytext", "GrayText");
        definedColorsATSC.put("highlight", "Highlight");
        definedColorsATSC.put("highlighttext", "HighlightText");
        definedColorsATSC.put("inactiveborder", "InactiveBorder");
        definedColorsATSC.put("inactivecaption", "InactiveCaption");
        definedColorsATSC.put("inactivecaptiontext", "InactiveCaptionText");
        definedColorsATSC.put("infobackground", "InfoBackground");
        definedColorsATSC.put("infotext", "InfoText");
        definedColorsATSC.put("menu", "Menu");
        definedColorsATSC.put("menutext", "MenuText");
        definedColorsATSC.put("scrollbar", "Scrollbar");
        definedColorsATSC.put("threeddarkshadow", "ThreeDDarkShadow");
        definedColorsATSC.put("threedface", "ThreeDFace");
        definedColorsATSC.put("threedhighlight", "ThreeDHighlight");
        definedColorsATSC.put("threedlightshadow", "ThreeDLightShadow");
        definedColorsATSC.put("threedshadow", "ThreeDShadow");
        definedColorsATSC.put("window", "Window");
        definedColorsATSC.put("windowframe", "WindowFrame");
        definedColorsATSC.put("windowtext", "WindowText");
    }
}

