/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import org.w3c.css.util.Warning;

public final class Warnings {
    private Warning[] warningData = new Warning[20];
    private int warningCount = 0;
    private int ignoredWarningCount = 0;
    private int warningLevel = 0;

    public Warnings() {
    }

    public Warnings(int level) {
        this.warningLevel = level;
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int warningLevel) {
        this.warningLevel = warningLevel;
    }

    public final void addWarning(Warning warm) {
        if (warm.getLevel() > this.warningLevel) {
            ++this.ignoredWarningCount;
        } else {
            this.resize(1);
            this.warningData[this.warningCount++] = warm;
        }
    }

    public final void addWarnings(Warnings warnings) {
        for (int i = 0; i < warnings.warningCount; ++i) {
            this.addWarning(warnings.warningData[i]);
        }
    }

    public final int getWarningCount() {
        return this.warningCount;
    }

    public final int getIgnoredWarningCount() {
        return this.ignoredWarningCount;
    }

    public final Warning[] getWarnings() {
        int oldCapacity = this.warningData.length;
        if (this.warningCount < oldCapacity) {
            Warning[] oldData = this.warningData;
            this.warningData = new Warning[this.warningCount];
            System.arraycopy(oldData, 0, this.warningData, 0, this.warningCount);
        }
        return this.warningData;
    }

    public final void sort() {
        this.quickSort(0, this.warningCount - 1);
    }

    private int partition(int part_low_ind, int part_high_ind) {
        int comp1 = (part_low_ind + part_high_ind) / 2;
        Warning transit = this.warningData[part_low_ind];
        this.warningData[part_low_ind] = this.warningData[comp1];
        this.warningData[comp1] = transit;
        long median_val = this.warningData[part_low_ind].getInternalOrder();
        int lastsmall = part_low_ind;
        for (int i = part_low_ind + 1; i <= part_high_ind; ++i) {
            if ((long)this.warningData[i].getInternalOrder() >= median_val) continue;
            transit = this.warningData[++lastsmall];
            this.warningData[lastsmall] = this.warningData[i];
            this.warningData[i] = transit;
        }
        transit = this.warningData[part_low_ind];
        this.warningData[part_low_ind] = this.warningData[lastsmall];
        this.warningData[lastsmall] = transit;
        return lastsmall;
    }

    private void quickSort(int qk_low_ind, int qk_high_ind) {
        if (qk_low_ind < qk_high_ind) {
            int median = this.partition(qk_low_ind, qk_high_ind);
            this.quickSort(qk_low_ind, median);
            this.quickSort(median + 1, qk_high_ind);
        }
    }

    public final Warning getWarningAt(int index) {
        return this.warningData[index];
    }

    private final void resize(int increment) {
        int oldCapacity = this.warningData.length;
        if (this.warningCount + increment + 1 > oldCapacity) {
            Warning[] oldData = this.warningData;
            this.warningData = new Warning[oldCapacity + increment + 1];
            System.arraycopy(oldData, 0, this.warningData, 0, this.warningCount);
        }
    }
}

