/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.svg.SVGBasicStyle;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class SolidOpacity
extends CssProperty {
    CssValue opaclevel;
    ApplContext ac;

    public SolidOpacity() {
        CssNumber cssnum = new CssNumber(1.0f);
        this.opaclevel = cssnum;
    }

    public SolidOpacity(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.ac = ac;
        this.setByUser();
        CssValue val = expression.getValue();
        if (val instanceof CssNumber) {
            CssNumber cssnum = new CssNumber(this.clampedValue(ac, ((CssNumber)val).getValue()));
            this.opaclevel = cssnum;
            expression.next();
        } else if (val instanceof CssIdent) {
            if (val.equals(inherit)) {
                this.opaclevel = inherit;
                expression.next();
            }
        } else {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
    }

    public SolidOpacity(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private float clampedValue(ApplContext ac, float opac) {
        if (opac < 0.0f || opac > 1.0f) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(opac));
            return !(opac < 0.0f) ? 1 : 0;
        }
        return opac;
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((SVGBasicStyle)style).solidOpacity != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((SVGBasicStyle)style).solidOpacity = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((SVGBasicStyle)style).getSolidOpacity();
        }
        return ((SVGBasicStyle)style).solidOpacity;
    }

    public boolean equals(CssProperty property) {
        return property instanceof SolidOpacity && this.opaclevel.equals(((SolidOpacity)property).opaclevel);
    }

    public String getPropertyName() {
        return "solid-opacity";
    }

    public Object get() {
        return this.opaclevel;
    }

    public boolean isSoftlyInherited() {
        return this.opaclevel.equals(inherit);
    }

    public String toString() {
        return this.opaclevel.toString();
    }

    public boolean isDefault() {
        CssNumber cssnum = new CssNumber(this.ac, 1.0f);
        return this.opaclevel == cssnum;
    }
}

