/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import org.w3c.css.css.StyleSheetOrigin;
import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperties;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Messages;
import org.w3c.css.values.CssIdent;

public abstract class CssProperty
implements Cloneable,
StyleSheetOrigin {
    public boolean important;
    public int origin;
    public long order = increment++;
    public int line;
    public String sourceFile;
    public CssSelectors context;
    private static long increment;
    public boolean byUser = false;
    public static final CssIdent inherit;
    public static final CssIdent transparent;
    public static final CssIdent initial;
    public static final CssIdent none;

    public boolean inherited() {
        return CssProperties.getInheritance(this);
    }

    public boolean isSoftlyInherited() {
        return false;
    }

    public abstract Object get();

    public abstract String getPropertyName();

    public String getPropertyNameEscaped() {
        return Messages.escapeString(this.getPropertyName());
    }

    public abstract boolean equals(CssProperty var1);

    public void print(CssPrinterStyle printer) {
        if (this.byUser || this.inherited() || this.important) {
            printer.print(this);
        }
    }

    public abstract String toString();

    public String getEscaped() {
        return Messages.escapeString(this.toString());
    }

    public void setImportant() {
        this.important = true;
    }

    public boolean getImportant() {
        return this.important;
    }

    public final int hashCode() {
        return this.getPropertyName().hashCode();
    }

    public void setInfo(int line, String source) {
        this.line = line;
        this.sourceFile = source;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getOrigin() {
        return this.origin;
    }

    public boolean isDefault() {
        return false;
    }

    public void setSelectors(CssSelectors context) {
        this.context = context;
    }

    public CssSelectors getSelectors() {
        return this.context;
    }

    public CssProperty duplicate() {
        try {
            return (CssProperty)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract void addToStyle(ApplContext var1, CssStyle var2);

    public abstract CssProperty getPropertyInStyle(CssStyle var1, boolean var2);

    public final String getSourceFile() {
        return this.sourceFile;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getExplicitWeight() {
        return this.origin + (this.important ? 3 : 0);
    }

    public final long getOrderSpecified() {
        return this.order;
    }

    public void setByUser() {
        this.byUser = true;
    }

    public boolean isByUser() {
        return this.byUser;
    }

    static {
        inherit = CssIdent.getIdent("inherit");
        transparent = CssIdent.getIdent("transparent");
        initial = CssIdent.getIdent("initial");
        none = CssIdent.getIdent("none");
    }
}

