/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.Css3Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class CssColumnCount
extends CssProperty {
    private static final String propertyName = "column-count";
    CssValue count;
    static CssIdent auto = CssIdent.getIdent("auto");

    public CssColumnCount() {
        this.count = auto;
    }

    public CssColumnCount(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 5: {
                CssNumber num = (CssNumber)val;
                if (!num.isInteger()) {
                    throw new InvalidParamException("integer", expression.getValue(), this.getPropertyName(), ac);
                }
                if (num.getInt() <= 0) {
                    throw new InvalidParamException("strictly-positive", expression.getValue(), this.getPropertyName(), ac);
                }
                this.count = val;
                break;
            }
            case 0: {
                if (auto.equals(val)) {
                    this.count = auto;
                    break;
                }
                if (inherit.equals(val)) {
                    this.count = inherit;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssColumnCount(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((Css3Style)style).cssColumnCount != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((Css3Style)style).cssColumnCount = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css3Style)style).getColumnCount();
        }
        return ((Css3Style)style).cssColumnCount;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssColumnCount && this.count.equals(((CssColumnCount)property).count);
    }

    public final String getPropertyName() {
        return propertyName;
    }

    public Object get() {
        return this.count;
    }

    public boolean isSoftlyInherited() {
        return this.count == inherit;
    }

    public String toString() {
        return this.count.toString();
    }

    public boolean isDefault() {
        return this.count == auto;
    }
}

