/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.aural;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.aural.ACssProperty;
import org.w3c.css.properties.aural.ACssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class ACssElevation
extends ACssProperty {
    CssValue value = defaultValue;
    private static int[] hash_values;
    private static String[] ELEVATION;
    private static CssValue defaultValue;

    public ACssElevation() {
    }

    public ACssElevation(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this();
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val.equals(inherit)) {
            this.value = inherit;
            expression.next();
            return;
        }
        if (val instanceof CssIdent) {
            this.value = this.checkIdent(ac, (CssIdent)val);
            expression.next();
            return;
        }
        if (val instanceof CssAngle) {
            float v = ((CssAngle)val).getDegree();
            if (v > 90.0f && v < 270.0f) {
                throw new InvalidParamException("elevation.range", null, ac);
            }
            this.value = val;
            expression.next();
            return;
        }
        throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
    }

    public ACssElevation(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public String getPropertyName() {
        return "elevation";
    }

    public boolean isSoftlyInherited() {
        return this.value.equals(inherit);
    }

    public String toString() {
        return this.value.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((ACssStyle)style).acssElevation != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((ACssStyle)style).acssElevation = this;
    }

    public boolean equals(CssProperty property) {
        return property instanceof ACssElevation && this.value.equals(((ACssElevation)property).value);
    }

    private CssIdent checkIdent(ApplContext ac, CssIdent ident) throws InvalidParamException {
        int hash = ident.hashCode();
        for (int i = 0; i < ELEVATION.length; ++i) {
            if (hash_values[i] != hash) continue;
            return ident;
        }
        throw new InvalidParamException("value", ident.toString(), this.getPropertyName(), ac);
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ACssStyle)style).getElevation();
        }
        return ((ACssStyle)style).acssElevation;
    }

    static {
        ELEVATION = new String[]{"below", "level", "above", "highter", "lower"};
        defaultValue = new CssIdent(ELEVATION[1]);
        hash_values = new int[ELEVATION.length];
        for (int i = 0; i < ELEVATION.length; ++i) {
            ACssElevation.hash_values[i] = ELEVATION[i].hashCode();
        }
    }
}

