/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.webhook;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.stream.JsonParsingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.vx68k.bitbucket.webhook.BitbucketEvent;

public class BitbucketWebhookServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF8 = "UTF-8";
    private final Event<BitbucketEvent> bitbucketEvent;

    @Inject
    public BitbucketWebhookServlet(Event<BitbucketEvent> event) {
        this.bitbucketEvent = event;
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Throwable throwable;
        String contentType = request.getContentType();
        if (contentType != null && contentType.contains(";")) {
            contentType = contentType.substring(0, contentType.indexOf(";")).trim();
        }
        if (!APPLICATION_JSON.equalsIgnoreCase(contentType)) {
            this.log("Unexpected content type: " + contentType);
            response.sendError(406);
            return;
        }
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(UTF8);
        }
        try {
            throwable = null;
            try (JsonReader reader = Json.createReader((Reader)request.getReader());){
                JsonObject object = reader.readObject();
                this.bitbucketEvent.fire((Object)new BitbucketEvent(object));
            }
            catch (Throwable object) {
                throwable = object;
                throw object;
            }
        }
        catch (JsonParsingException exception) {
            this.log("JSON parsing error", exception);
            response.sendError(403);
            return;
        }
        response.setStatus(200);
        response.setContentType(APPLICATION_JSON);
        response.setCharacterEncoding(UTF8);
        throwable = null;
        try (JsonWriter writer = Json.createWriter((Writer)response.getWriter());){
            JsonObjectBuilder builder = Json.createObjectBuilder().add("status", "OK");
            writer.write((JsonStructure)builder.build());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }
}

