/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.webhook;

import java.util.List;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.vx68k.bitbucket.api.BitbucketBranch;
import org.vx68k.bitbucket.api.BitbucketCommit;
import org.vx68k.bitbucket.api.client.BitbucketClientBranch;
import org.vx68k.bitbucket.api.client.BitbucketClientCommit;
import org.vx68k.bitbucket.api.client.BitbucketClientObject;

public class BitbucketPush
extends BitbucketClientObject {
    private static final String CHANGES = "changes";

    public BitbucketPush(JsonObject pushObject) {
        super(pushObject);
    }

    public final List<Change> getChanges() {
        JsonObject object = this.getJsonObject();
        JsonArray array = object.getJsonArray(CHANGES);
        List changes = null;
        if (array != null) {
            changes = array.stream().map(x -> new Change((JsonObject)x)).collect(Collectors.toList());
        }
        return changes;
    }

    public static class Change
    extends BitbucketClientObject {
        private static final String CREATED = "created";
        private static final String CLOSED = "closed";
        private static final String FORCED = "forced";
        private static final String TRUNCATED = "truncated";
        private static final String OLD = "old";
        private static final String NEW = "new";
        private static final String COMMITS = "commits";

        public Change(JsonObject object) {
            super(object);
        }

        public final boolean isCreated() {
            JsonObject object = this.getJsonObject();
            return object.getBoolean(CREATED, false);
        }

        public final boolean isClosed() {
            JsonObject object = this.getJsonObject();
            return object.getBoolean(CLOSED, false);
        }

        public final boolean isForced() {
            JsonObject object = this.getJsonObject();
            return object.getBoolean(FORCED, false);
        }

        public final boolean isTruncated() {
            JsonObject object = this.getJsonObject();
            return object.getBoolean(TRUNCATED, false);
        }

        public final BitbucketBranch getOld() {
            JsonObject object = this.getJsonObject();
            BitbucketClientBranch value = null;
            if (object.containsKey((Object)OLD) && !object.isNull(OLD)) {
                value = new BitbucketClientBranch(object.getJsonObject(OLD));
            }
            return value;
        }

        public final BitbucketBranch getNew() {
            JsonObject object = this.getJsonObject();
            BitbucketClientBranch value = null;
            if (object.containsKey((Object)NEW) && !object.isNull(NEW)) {
                value = new BitbucketClientBranch(object.getJsonObject(NEW));
            }
            return value;
        }

        public final List<BitbucketCommit> getCommits() {
            JsonObject object = this.getJsonObject();
            JsonArray array = object.getJsonArray(COMMITS);
            List commits = null;
            if (array != null) {
                commits = array.stream().map(x -> new BitbucketClientCommit((JsonObject)x)).collect(Collectors.toList());
            }
            return commits;
        }
    }
}

