/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.UUID;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.ws.rs.core.Link;

public class JsonUtilities {
    private static final String HREF = "href";

    protected JsonUtilities() {
    }

    public static Instant toInstant(JsonString string) {
        Instant value = null;
        if (string != null) {
            value = OffsetDateTime.parse(string.getString()).toInstant();
        }
        return value;
    }

    public static UUID toUUID(JsonString string) {
        UUID value = null;
        if (string != null) {
            String uuidString = string.getString();
            if (uuidString.startsWith("{") && uuidString.endsWith("}")) {
                uuidString = uuidString.substring(1, uuidString.length() - 1);
            }
            value = UUID.fromString(uuidString);
        }
        return value;
    }

    public static Link toLink(JsonObject object) {
        Link value = null;
        if (object != null && object.containsKey((Object)HREF)) {
            value = Link.fromUri((String)object.getString(HREF)).build(new Object[0]);
        }
        return value;
    }
}

