/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.ws.rs.core.Link;
import org.vx68k.bitbucket.api.BitbucketAccount;
import org.vx68k.bitbucket.api.BitbucketBranch;
import org.vx68k.bitbucket.api.BitbucketIssue;
import org.vx68k.bitbucket.api.BitbucketIssueTracker;
import org.vx68k.bitbucket.api.BitbucketRepository;
import org.vx68k.bitbucket.api.client.BitbucketClient;
import org.vx68k.bitbucket.api.client.BitbucketClientAccount;
import org.vx68k.bitbucket.api.client.BitbucketClientBranch;
import org.vx68k.bitbucket.api.client.BitbucketClientIssue;
import org.vx68k.bitbucket.api.client.BitbucketClientObject;
import org.vx68k.bitbucket.api.client.BitbucketClientUser;
import org.vx68k.bitbucket.api.client.JsonUtilities;
import org.vx68k.bitbucket.api.client.PaginatedList;

public class BitbucketClientRepository
extends BitbucketClientObject
implements BitbucketRepository,
BitbucketIssueTracker {
    private static final String REPOSITORY = "repository";
    private static final String CREATED_ON = "created_on";
    private static final String DESCRIPTION = "description";
    private static final String FORK_POLICY = "fork_policy";
    private static final String FULL_NAME = "full_name";
    private static final String HAS_ISSUES = "has_issues";
    private static final String HAS_WIKI = "has_wiki";
    private static final String IS_PRIVATE = "is_private";
    private static final String LANGUAGE = "language";
    private static final String MAINBRANCH = "mainbranch";
    private static final String NAME = "name";
    private static final String OWNER = "owner";
    private static final String PROJECT = "project";
    private static final String SCM = "scm";
    private static final String SIZE = "size";
    private static final String UPDATED_ON = "updated_on";
    private static final String UUID = "uuid";
    private static final String WEBSITE = "website";

    public BitbucketClientRepository(JsonObject object) {
        this(object, null);
    }

    public BitbucketClientRepository(JsonObject object, BitbucketClient client) {
        super(object, client);
        String type = this.getType();
        if (type == null || !type.equals(REPOSITORY)) {
            throw new IllegalArgumentException("Not repository");
        }
    }

    public static Function<JsonObject, BitbucketClientRepository> creator() {
        return BitbucketClientRepository.creator(null);
    }

    public static Function<JsonObject, BitbucketClientRepository> creator(BitbucketClient bitbucketClient) {
        return object -> new BitbucketClientRepository((JsonObject)object, bitbucketClient);
    }

    @Override
    public final String getSCM() {
        JsonObject object = this.getJsonObject();
        return object.getString(SCM, null);
    }

    @Override
    public final BitbucketAccount getOwner() {
        JsonObject object = this.getJsonObject();
        BitbucketClientAccount value = null;
        JsonObject owner = object.getJsonObject(OWNER);
        if (owner != null) {
            BitbucketClient client = this.getBitbucketClient();
            String type = owner.getString("type");
            value = type.equals("team") ? new BitbucketClientAccount(owner, client) : new BitbucketClientUser(owner, client);
        }
        return value;
    }

    @Override
    public final String getName() {
        JsonObject object = this.getJsonObject();
        return object.getString(NAME, null);
    }

    @Override
    public final UUID getUUID() {
        JsonObject object = this.getJsonObject();
        return JsonUtilities.toUUID(object.getJsonString(UUID));
    }

    @Override
    public final String getFullName() {
        JsonObject object = this.getJsonObject();
        return object.getString(FULL_NAME, null);
    }

    @Override
    public final String getDescription() {
        JsonObject object = this.getJsonObject();
        return object.getString(DESCRIPTION, null);
    }

    @Override
    public final boolean isPrivate() {
        JsonObject object = this.getJsonObject();
        return object.getBoolean(IS_PRIVATE, false);
    }

    @Override
    public final BitbucketBranch getMainBranch() {
        JsonObject branch = this.getJsonObject().getJsonObject(MAINBRANCH);
        BitbucketClientBranch value = null;
        if (branch != null) {
            value = new BitbucketClientBranch(branch, this.getBitbucketClient());
        }
        return value;
    }

    @Override
    public final boolean hasIssueTracker() {
        return this.getJsonObject().getBoolean(HAS_ISSUES, false);
    }

    @Override
    public final boolean hasWiki() {
        return this.getJsonObject().getBoolean(HAS_WIKI, false);
    }

    @Override
    public final long getSize() {
        JsonNumber size = this.getJsonObject().getJsonNumber(SIZE);
        long value = -1L;
        if (size != null) {
            value = size.longValue();
        }
        return value;
    }

    @Override
    public final Instant getCreated() {
        JsonObject object = this.getJsonObject();
        Instant value = null;
        if (object.containsKey((Object)CREATED_ON) && !object.isNull(CREATED_ON)) {
            value = JsonUtilities.toInstant(object.getJsonString(CREATED_ON));
        }
        return value;
    }

    @Override
    public final Instant getUpdated() {
        JsonObject object = this.getJsonObject();
        Instant value = null;
        if (object.containsKey((Object)UPDATED_ON) && !object.isNull(UPDATED_ON)) {
            value = JsonUtilities.toInstant(object.getJsonString(UPDATED_ON));
        }
        return value;
    }

    @Override
    public final BitbucketIssueTracker getIssueTracker() {
        BitbucketClientRepository value = null;
        if (this.hasIssueTracker()) {
            value = this;
        }
        return value;
    }

    @Override
    public final BitbucketRepository getRepository() {
        return this;
    }

    @Override
    public final BitbucketIssue getIssue(int id) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(OWNER, this.getOwner().getName());
        parameters.put(NAME, this.getName());
        parameters.put("id", id);
        BitbucketClient client = this.getBitbucketClient();
        JsonObject object = client.getResource("/repositories/{owner}/{name}/issues/{id}", parameters);
        BitbucketClientIssue value = null;
        if (object != null) {
            value = new BitbucketClientIssue(object, client);
        }
        return value;
    }

    @Override
    public final Collection<BitbucketIssue> issues() {
        return this.issues(null);
    }

    @Override
    public final Collection<BitbucketIssue> issues(String filter) {
        Link issues = this.getLink("issues");
        URI uri = filter != null ? issues.getUriBuilder().queryParam("q", new Object[]{filter}).build(new Object[0]) : issues.getUri();
        BitbucketClient client = this.getBitbucketClient();
        return new PaginatedList<BitbucketIssue>(uri, client, BitbucketClientIssue.creator(client));
    }
}

