/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.time.Instant;
import java.util.function.Function;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.vx68k.bitbucket.api.BitbucketIssue;
import org.vx68k.bitbucket.api.BitbucketRendered;
import org.vx68k.bitbucket.api.BitbucketRepository;
import org.vx68k.bitbucket.api.BitbucketUser;
import org.vx68k.bitbucket.api.client.BitbucketClient;
import org.vx68k.bitbucket.api.client.BitbucketClientObject;
import org.vx68k.bitbucket.api.client.BitbucketClientRendered;
import org.vx68k.bitbucket.api.client.BitbucketClientRepository;
import org.vx68k.bitbucket.api.client.BitbucketClientUser;
import org.vx68k.bitbucket.api.client.JsonUtilities;

public class BitbucketClientIssue
extends BitbucketClientObject
implements BitbucketIssue {
    private static final String ISSUE = "issue";
    private static final String ASSIGNEE = "assignee";
    private static final String COMPONENT = "component";
    private static final String CONTENT = "content";
    private static final String CREATED_ON = "created_on";
    private static final String EDITED_ON = "edited_on";
    private static final String ID = "id";
    private static final String KIND = "kind";
    private static final String MILESTONE = "milestone";
    private static final String PRIORITY = "priority";
    private static final String REPORTER = "reporter";
    private static final String REPOSITORY = "repository";
    private static final String STATE = "state";
    private static final String TITLE = "title";
    private static final String UPDATED_ON = "updated_on";
    private static final String VERSION = "version";
    private static final String VOTES = "votes";
    private static final String WATCHES = "watches";

    public BitbucketClientIssue(JsonObject jsonObject) {
        this(jsonObject, null);
    }

    public BitbucketClientIssue(JsonObject jsonObject, BitbucketClient bitbucketClient) {
        super(jsonObject, bitbucketClient);
        String type = this.getType();
        if (!ISSUE.equals(type)) {
            throw new IllegalArgumentException("Object is not of an issue");
        }
    }

    public static Function<JsonObject, BitbucketClientIssue> creator() {
        return BitbucketClientIssue.creator(null);
    }

    public static Function<JsonObject, BitbucketClientIssue> creator(BitbucketClient bitbucketClient) {
        return object -> new BitbucketClientIssue((JsonObject)object, bitbucketClient);
    }

    @Override
    public final BitbucketRepository getRepository() {
        JsonObject object = this.getJsonObject();
        JsonObject repository = object.getJsonObject(REPOSITORY);
        BitbucketClientRepository value = null;
        if (repository != null) {
            value = new BitbucketClientRepository(repository, this.getBitbucketClient());
        }
        return value;
    }

    @Override
    public final int getId() {
        return this.getJsonObject().getInt(ID, 0);
    }

    @Override
    public final BitbucketUser getReporter() {
        JsonValue reporter = (JsonValue)this.getJsonObject().get((Object)REPORTER);
        BitbucketClientUser value = null;
        if (reporter != null && reporter != JsonValue.NULL) {
            value = new BitbucketClientUser((JsonObject)reporter, this.getBitbucketClient());
        }
        return value;
    }

    @Override
    public final String getState() {
        return this.getJsonObject().getString(STATE, null);
    }

    @Override
    public final String getKind() {
        return this.getJsonObject().getString(KIND, null);
    }

    @Override
    public final String getPriority() {
        return this.getJsonObject().getString(PRIORITY, null);
    }

    @Override
    public final String getTitle() {
        return this.getJsonObject().getString(TITLE, null);
    }

    @Override
    public final BitbucketRendered getContent() {
        JsonObject content = this.getJsonObject().getJsonObject(CONTENT);
        BitbucketClientRendered value = null;
        if (content != null) {
            value = new BitbucketClientRendered(content);
        }
        return value;
    }

    @Override
    public final BitbucketUser getAssignee() {
        JsonValue assignee = (JsonValue)this.getJsonObject().get((Object)ASSIGNEE);
        BitbucketClientUser value = null;
        if (assignee != null && assignee != JsonValue.NULL) {
            value = new BitbucketClientUser((JsonObject)assignee, this.getBitbucketClient());
        }
        return value;
    }

    @Override
    public final BitbucketIssue.Component getComponent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final BitbucketIssue.Milestone getMilestone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final BitbucketIssue.Version getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final int getVotes() {
        JsonNumber votes = this.getJsonObject().getJsonNumber(VOTES);
        int value = -1;
        if (votes != null) {
            value = votes.intValue();
        }
        return value;
    }

    @Override
    public final int getWatches() {
        JsonNumber watches = this.getJsonObject().getJsonNumber(WATCHES);
        int value = -1;
        if (watches != null) {
            value = watches.intValue();
        }
        return value;
    }

    @Override
    public final Instant getCreated() {
        JsonValue createdOn = (JsonValue)this.getJsonObject().get((Object)CREATED_ON);
        Instant value = null;
        if (createdOn != null && createdOn != JsonValue.NULL) {
            value = JsonUtilities.toInstant((JsonString)createdOn);
        }
        return value;
    }

    @Override
    public final Instant getUpdated() {
        JsonValue updatedOn = (JsonValue)this.getJsonObject().get((Object)UPDATED_ON);
        Instant value = null;
        if (updatedOn != null && updatedOn != JsonValue.NULL) {
            value = JsonUtilities.toInstant((JsonString)updatedOn);
        }
        return value;
    }

    @Override
    public final Instant getEdited() {
        JsonValue editedOn = (JsonValue)this.getJsonObject().get((Object)EDITED_ON);
        Instant value = null;
        if (editedOn != null && editedOn != JsonValue.NULL) {
            value = JsonUtilities.toInstant((JsonString)editedOn);
        }
        return value;
    }
}

