/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import javax.json.JsonObject;
import javax.ws.rs.core.Link;
import org.vx68k.bitbucket.api.BitbucketAccount;
import org.vx68k.bitbucket.api.BitbucketRepository;
import org.vx68k.bitbucket.api.client.BitbucketClient;
import org.vx68k.bitbucket.api.client.BitbucketClientObject;
import org.vx68k.bitbucket.api.client.BitbucketClientRepository;
import org.vx68k.bitbucket.api.client.JsonUtilities;
import org.vx68k.bitbucket.api.client.PaginatedList;

public class BitbucketClientAccount
extends BitbucketClientObject
implements BitbucketAccount {
    private static final String CREATED_ON = "created_on";
    private static final String DISPLAY_NAME = "display_name";
    private static final String LOCATION = "location";
    private static final String USERNAME = "username";
    private static final String UUID = "uuid";
    private static final String WEBSITE = "website";
    private static final String REPOSITORIES = "repositories";

    public BitbucketClientAccount(JsonObject object) {
        this(object, null);
    }

    public BitbucketClientAccount(JsonObject object, BitbucketClient client) {
        super(object, client);
        String type = this.getType();
        if (!"user".equals(type) && !"team".equals(type)) {
            throw new IllegalArgumentException("JSON object type is not user or team");
        }
    }

    @Override
    public final String getName() {
        JsonObject object = this.getJsonObject();
        return object.getString(USERNAME, null);
    }

    @Override
    public final UUID getUUID() {
        JsonObject object = this.getJsonObject();
        return JsonUtilities.toUUID(object.getJsonString(UUID));
    }

    @Override
    public final String getDisplayName() {
        JsonObject object = this.getJsonObject();
        return object.getString(DISPLAY_NAME, null);
    }

    @Override
    public final String getWebsite() {
        JsonObject object = this.getJsonObject();
        return object.getString(WEBSITE, null);
    }

    @Override
    public final String getLocation() {
        JsonObject object = this.getJsonObject();
        return object.getString(LOCATION, null);
    }

    @Override
    public final Instant getCreated() {
        JsonObject object = this.getJsonObject();
        Instant value = null;
        if (object.containsKey((Object)CREATED_ON) && !object.isNull(CREATED_ON)) {
            value = JsonUtilities.toInstant(object.getJsonString(CREATED_ON));
        }
        return value;
    }

    @Override
    public final BitbucketRepository getRepository(String name) {
        BitbucketClient client = this.getBitbucketClient();
        return client.getRepository(this.getName(), name);
    }

    @Override
    public final Collection<BitbucketRepository> repositories() {
        Link repositories = this.getLink(REPOSITORIES);
        PaginatedList<BitbucketClientRepository> value = null;
        if (repositories != null) {
            BitbucketClient client = this.getBitbucketClient();
            value = new PaginatedList<BitbucketClientRepository>(repositories.getUri(), client, BitbucketClientRepository.creator(client));
        }
        return value;
    }
}

