/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.linkeddatafragments.datasource.rdfservice;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.StringWriterI;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.linkeddatafragments.datasource.AbstractRequestProcessorForTriplePatterns;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragmentRequest;

public class RDFServiceBasedRequestProcessorForTPFs
extends AbstractRequestProcessorForTriplePatterns<RDFNode, String, String> {
    private static RDFService rdfService;

    public static void setRDFService(RDFService pRDFService) {
        rdfService = pRDFService;
    }

    protected Worker getTPFSpecificWorker(ITriplePatternFragmentRequest<RDFNode, String, String> request) throws IllegalArgumentException {
        return new Worker(request);
    }

    protected class Worker
    extends AbstractRequestProcessorForTriplePatterns.Worker<RDFNode, String, String> {
        public Worker(ITriplePatternFragmentRequest<RDFNode, String, String> req) {
            super(req);
        }

        private void appendNode(StringBuilder builder, RDFNode node) {
            if (node.isLiteral()) {
                builder.append(this.literalToString(node.asLiteral()));
            } else if (node.isURIResource()) {
                builder.append('<').append(node.asResource().getURI()).append('>');
            }
        }

        private String literalToString(Literal l) {
            StringWriterI sw = new StringWriterI();
            NodeFormatterTTL fmt = new NodeFormatterTTL(null, null);
            fmt.formatLiteral((AWriter)sw, l.asNode());
            return sw.toString();
        }

        private Node skolemize(Node node) {
            if (node != null && node.isBlank()) {
                return NodeFactory.createURI((String)("bnode://" + node.getBlankNodeLabel()));
            }
            return node;
        }

        private RDFNode deskolemize(RDFNode node) {
            String uri;
            if (node == null) {
                return null;
            }
            if (node.isResource() && (uri = node.asResource().getURI()) != null && uri.startsWith("bnode://")) {
                String bnodeId = uri.substring(8);
                return ModelFactory.createDefaultModel().asRDFNode(NodeFactory.createBlankNode((String)bnodeId));
            }
            return node;
        }

        @Override
        protected ILinkedDataFragment createFragment(ITriplePatternElement<RDFNode, String, String> subject, ITriplePatternElement<RDFNode, String, String> predicate, ITriplePatternElement<RDFNode, String, String> object, long offset, long limit) {
            try {
                RDFNode nSubject = subject.isVariable() ? null : this.deskolemize(subject.asConstantTerm());
                RDFNode nPredicate = predicate.isVariable() ? null : this.deskolemize(predicate.asConstantTerm());
                RDFNode nObject = object.isVariable() ? null : this.deskolemize(object.asConstantTerm());
                Model triples = rdfService.getTriples(nSubject, nPredicate, nObject, limit, offset);
                if (triples == null || triples.isEmpty()) {
                    return this.createEmptyTriplePatternFragment();
                }
                if (triples.size() > 0L) {
                    Model replacedBlankNodes = ModelFactory.createDefaultModel();
                    StmtIterator iter = triples.listStatements();
                    while (iter.hasNext()) {
                        Statement oldStmt = (Statement)iter.next();
                        Triple t = oldStmt.asTriple();
                        replacedBlankNodes.add(replacedBlankNodes.asStatement(new Triple(this.skolemize(t.getSubject()), this.skolemize(t.getPredicate()), this.skolemize(t.getObject()))));
                    }
                    triples = replacedBlankNodes;
                }
                long size = triples.size();
                long estimate = -1L;
                estimate = rdfService.countTriples(nSubject, nPredicate, nObject);
                if (estimate < offset + size) {
                    estimate = size == limit ? offset + size + 1L : offset + size;
                }
                boolean isLastPage = estimate < offset + limit;
                return this.createTriplePatternFragment(triples, estimate, isLastPage);
            }
            catch (RDFServiceException e) {
                return this.createEmptyTriplePatternFragment();
            }
        }
    }
}

