/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource;

import java.util.HashMap;
import java.util.Map;
import org.linkeddatafragments.datasource.IDataSourceType;

public class DataSourceTypesRegistry {
    private static Map<String, IDataSourceType> registry = new HashMap<String, IDataSourceType>();

    public static synchronized IDataSourceType getType(String typeName) {
        return registry.get(typeName);
    }

    public static synchronized boolean isRegistered(String typeName) {
        return registry.containsKey(typeName);
    }

    public static synchronized void register(String typeName, IDataSourceType type) {
        if (registry.containsKey(typeName)) {
            throw new IllegalArgumentException("The registry already contains a type with the name '" + typeName + "'.");
        }
        registry.put(typeName, type);
    }
}

