/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource;

import com.fasterxml.jackson.databind.JsonNode;
import org.linkeddatafragments.datasource.DataSourceTypesRegistry;
import org.linkeddatafragments.datasource.IDataSource;
import org.linkeddatafragments.datasource.IDataSourceType;
import org.linkeddatafragments.exceptions.DataSourceCreationException;
import org.linkeddatafragments.exceptions.UnknownDataSourceTypeException;

public class DataSourceFactory {
    public static IDataSource create(JsonNode config) throws DataSourceCreationException {
        String title = config.get("title").asText();
        String description = config.get("description").asText();
        String typeName = config.get("type").asText();
        JsonNode settings = config.get("settings");
        IDataSourceType type = DataSourceTypesRegistry.getType(typeName);
        if (type == null) {
            throw new UnknownDataSourceTypeException(typeName);
        }
        return type.createDataSource(title, description, settings);
    }
}

