/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dump;

import freemarker.core.Environment;
import freemarker.ext.dump.BaseDumpDirective;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DumpDirective
extends BaseDumpDirective {
    private static final Log log = LogFactory.getLog(DumpDirective.class);

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (loopVars.length != 0) {
            throw new TemplateModelException("The dump directive doesn't allow loop variables.");
        }
        if (body != null) {
            throw new TemplateModelException("The dump directive doesn't allow nested content.");
        }
        Object o = params.get("var");
        if (o == null) {
            throw new TemplateModelException("Must specify 'var' argument.");
        }
        if (!(o instanceof SimpleScalar)) {
            throw new TemplateModelException("Value of parameter 'var' must be a string.");
        }
        String varName = o.toString();
        Map<String, Object> map = this.getTemplateVariableDump(varName, env);
        String title = "Template variable dump";
        this.dump(map, env, title);
    }

    @Override
    public Map<String, Object> help(String name) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("effect", "Dumps the contents of a template variable.");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("var", "name of variable to dump");
        map.put("parameters", params);
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("<@" + name + " var=\"urls\" />");
        map.put("examples", examples);
        return map;
    }
}

