/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.vitro.opensocial;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class OpenSocialSmokeTests
implements ServletContextListener {
    private static final String PROPERTY_SHINDIG_URL = "OpenSocial.shindigURL";
    private static final String PROPERTY_SHINDIG_TOKEN_KEY_FILE = "OpenSocial.tokenKeyFile";
    private static final String PROPERTY_SHINDIG_TOKEN_SERVICE = "OpenSocial.tokenService";
    private static final String PROPERTY_DB_DRIVER = "VitroConnection.DataSource.driver";
    private static final String PROPERTY_DB_JDBC_URL = "VitroConnection.DataSource.url";
    private static final String PROPERTY_DB_USERNAME = "VitroConnection.DataSource.username";
    private static final String PROPERTY_DB_PASSWORD = "VitroConnection.DataSource.password";
    private static final String FILENAME_SHINDIG_PROPERTIES = "shindigorng.properties";
    private static final long SLEEP_INTERVAL = 20000L;
    private ServletContext ctx;
    private ConfigurationProperties configProps;
    private List<Warning> warnings = new ArrayList<Warning>();
    private String shindigBaseUrl;
    private String tokenServiceHost;
    private int tokenServicePort;

    public void contextInitialized(ServletContextEvent sce) {
        this.ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(this.ctx);
        this.configProps = ConfigurationProperties.getBean(this.ctx);
        if (!this.configurationPresent()) {
            ss.info(this, "The OpenSocial connection is not configured.");
            return;
        }
        this.checkDatabaseTables();
        this.checkShindigConfigFile();
        this.checkTokenKeyFile();
        this.checkTokenServiceInfo();
        if (!this.warnings.isEmpty()) {
            for (Warning w : this.warnings) {
                w.warn(ss);
            }
            return;
        }
        ss.info(this, "Starting threads for OpenSocial smoke tests");
        new ShindigTestThread(this, ss, this.shindigBaseUrl).start();
        new TokenServiceTestThread(this, ss, this.tokenServiceHost, this.tokenServicePort).start();
    }

    private boolean configurationPresent() {
        String shindigUrl = this.configProps.getProperty(PROPERTY_SHINDIG_URL);
        if (StringUtils.isNotEmpty((CharSequence)shindigUrl)) {
            this.shindigBaseUrl = shindigUrl;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabaseTables() {
        BasicDataSource dataSource = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        try {
            dataSource = new BasicDataSource();
            dataSource.setDriverClassName(this.getProperty(PROPERTY_DB_DRIVER));
            dataSource.setUrl(this.getProperty(PROPERTY_DB_JDBC_URL));
            dataSource.setUsername(this.getProperty(PROPERTY_DB_USERNAME));
            dataSource.setPassword(this.getProperty(PROPERTY_DB_PASSWORD));
            conn = dataSource.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery("select * from orng_apps");
        }
        catch (NoSuchPropertyException e) {
            this.warnings.add(new Warning(e.getMessage()));
        }
        catch (SQLException e) {
            if (e.getMessage().contains("doesn't exist")) {
                this.warnings.add(new Warning("The Shindig tables don't exist in the database. Was shindig_orng_tables.sql run to set them up?", e));
            } else {
                this.warnings.add(new Warning("Can't access the Shindig database tables", e));
            }
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkShindigConfigFile() {
        URL url = this.getClass().getResource("/shindigorng.properties");
        if (url == null) {
            String message = "Can't find the 'shindigorng.properties' file in the classpath. ";
            message = message + "Has the Tomcat classpath been set to include the Shindig config directory? (inside the Vitro home directory) ";
            message = message + "Was the openSocial build script run? ('ant orng')";
            this.warnings.add(new Warning(message));
        }
    }

    private void checkTokenKeyFile() {
        try {
            String tokenFilename = this.getProperty(PROPERTY_SHINDIG_TOKEN_KEY_FILE);
            File tokenFile = new File(tokenFilename);
            if (!tokenFile.exists()) {
                this.warnings.add(new Warning("Token key file for Shindig does not exist: '" + tokenFilename + "'"));
            } else if (!tokenFile.isFile()) {
                this.warnings.add(new Warning("Token key file for Shindig is not a file: '" + tokenFilename + "'"));
            }
        }
        catch (NoSuchPropertyException e) {
            this.warnings.add(new Warning(e.getMessage()));
        }
    }

    private void checkTokenServiceInfo() {
        String tsInfo = this.configProps.getProperty(PROPERTY_SHINDIG_TOKEN_SERVICE);
        if (StringUtils.isEmpty((CharSequence)tsInfo)) {
            this.warnings.add(new Warning("There is no value for 'OpenSocial.tokenService' in runtime.properties"));
            return;
        }
        String warningText = "The 'OpenSocial.tokenService' parameter is set to \"" + tsInfo + "\". It must be in the form [hostname]:[port]. For example, \"myhost.mydomain.edu:8777\". The hostname may be an IP address, but it may not be \"localhost\" or \"127.0.0.1\"";
        int firstColon = tsInfo.indexOf(58);
        if (firstColon <= 0) {
            this.warnings.add(new Warning(warningText));
            return;
        }
        int lastColon = tsInfo.lastIndexOf(58);
        if (firstColon != lastColon) {
            this.warnings.add(new Warning(warningText));
            return;
        }
        this.tokenServiceHost = tsInfo.substring(0, firstColon);
        if ("localhost".equals(this.tokenServiceHost) || "127.0.0.1".equals(this.tokenServiceHost)) {
            this.warnings.add(new Warning(warningText));
            return;
        }
        try {
            this.tokenServicePort = Integer.parseInt(tsInfo.substring(firstColon + 1));
        }
        catch (Exception e) {
            this.warnings.add(new Warning(warningText, e));
        }
    }

    private String getProperty(String key) throws NoSuchPropertyException {
        String value = this.configProps.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new NoSuchPropertyException(key);
        }
        return value;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    protected static class TokenServiceTesterException
    extends Exception {
        protected TokenServiceTesterException(String message) {
            super(message);
        }

        protected TokenServiceTesterException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class TokenServiceTester {
        private static final Log log = LogFactory.getLog(OpenSocialSmokeTests.class);
        private final String host;
        private final int port;
        private Object problem;

        public TokenServiceTester(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public void connect() throws TokenServiceTesterException {
            this.testConnection();
            if (!this.isDone()) {
                this.sleep();
                this.testConnection();
            }
            if (!this.isDone()) {
                this.sleep();
                this.testConnection();
            }
            if (this.problem instanceof Throwable) {
                throw new TokenServiceTesterException("Test of the Shindig token service failed.", (Throwable)this.problem);
            }
            if (this.problem instanceof String) {
                throw new TokenServiceTesterException((String)this.problem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testConnection() {
            try {
                log.debug((Object)"Connecting to the token service");
                try (Socket s = new Socket(this.host, this.port);){
                    s.getOutputStream().write("c=default\n".getBytes());
                    int byteCount = 0;
                    int totalBytecount = 0;
                    byte[] buffer = new byte[8192];
                    InputStream inputStream = s.getInputStream();
                    while ((byteCount = inputStream.read(buffer)) > 0) {
                        totalBytecount += byteCount;
                    }
                    if (totalBytecount == 0) {
                        log.debug((Object)"Received an empty response.");
                        this.problem = "The Shindig security token service responded to a test, but the response was empty.";
                    } else {
                        log.debug((Object)"Recieved the token.");
                        this.problem = null;
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)"Problem with the token service", (Throwable)e);
                this.problem = e;
            }
        }

        private boolean isDone() {
            return this.problem == null || this.problem instanceof String;
        }

        private void sleep() {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class TokenServiceTestThread
    extends VitroBackgroundThread {
        private final OpenSocialSmokeTests listener;
        private final StartupStatus ss;
        private final String tokenServiceHost;
        private final int tokenServicePort;

        public TokenServiceTestThread(OpenSocialSmokeTests listener, StartupStatus ss, String tokenServiceHost, int tokenServicePort) {
            super("OpenSocialSmokeTest.TokenServiceTestThread");
            this.listener = listener;
            this.ss = ss;
            this.tokenServiceHost = tokenServiceHost;
            this.tokenServicePort = tokenServicePort;
        }

        @Override
        public void run() {
            try {
                new TokenServiceTester(this.tokenServiceHost, this.tokenServicePort).connect();
                this.ss.info(this.listener, "Shindig security token service responds to a request.");
            }
            catch (TokenServiceTesterException e) {
                String message = e.getMessage();
                Throwable cause = e.getCause();
                if (cause == null) {
                    this.ss.warning(this.listener, message);
                }
                this.ss.warning(this.listener, message, cause);
            }
        }
    }

    protected static class ShindigTesterException
    extends Exception {
        private final int httpStatusCode;

        protected ShindigTesterException(Integer httpStatusCode, String baseUrl, String testUrl) {
            super("Failed to connect to the Shindig service at '" + baseUrl + "' (tried for a response at '" + testUrl + "'). status code was " + httpStatusCode);
            this.httpStatusCode = httpStatusCode;
        }

        protected ShindigTesterException(Throwable cause, String baseUrl, String testUrl) {
            super("Failed to connect to the Shindig service at '" + baseUrl + "' (tried for a response at '" + testUrl + "').", cause);
            this.httpStatusCode = Integer.MIN_VALUE;
        }

        protected int getHttpStatusCode() {
            return this.httpStatusCode;
        }
    }

    private static class ShindigTester {
        private static final Log log = LogFactory.getLog(OpenSocialSmokeTests.class);
        private static final int SOCKET_TIMEOUT_STATUS = -500;
        private final String shindigBaseUrl;
        private final String shindigTestUrl;
        private final HttpClient httpClient = HttpClientFactory.getHttpClient();
        private int statusCode = Integer.MIN_VALUE;

        public ShindigTester(String shindigBaseUrl) {
            this.shindigBaseUrl = shindigBaseUrl;
            this.shindigTestUrl = shindigBaseUrl + "/rest/appdata";
        }

        public void connect() throws ShindigTesterException {
            this.testConnection();
            if (!this.isDone()) {
                this.sleep();
                this.testConnection();
            }
            if (!this.isDone()) {
                this.sleep();
                this.testConnection();
            }
            if (this.statusCode != 200) {
                throw new ShindigTesterException(this.statusCode, this.shindigBaseUrl, this.shindigTestUrl);
            }
        }

        private void testConnection() throws ShindigTesterException {
            HttpGet method = new HttpGet(this.shindigTestUrl);
            try {
                log.debug((Object)"Trying to connect to Shindig");
                HttpResponse response = this.httpClient.execute((HttpUriRequest)method);
                try {
                    this.statusCode = response.getStatusLine().getStatusCode();
                    log.debug((Object)("HTTP status was " + this.statusCode));
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (SocketTimeoutException e) {
                this.statusCode = -500;
            }
            catch (Exception e) {
                throw new ShindigTesterException(e, this.shindigBaseUrl, this.shindigTestUrl);
            }
        }

        private boolean isDone() {
            return this.statusCode == 200 || this.statusCode == 403;
        }

        private void sleep() {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class ShindigTestThread
    extends VitroBackgroundThread {
        private final OpenSocialSmokeTests listener;
        private final StartupStatus ss;
        private final String shindigBaseUrl;

        public ShindigTestThread(OpenSocialSmokeTests listener, StartupStatus ss, String shindigBaseUrl) {
            super("OpenSocialSmokeTest.ShindigTestThread");
            this.listener = listener;
            this.ss = ss;
            this.shindigBaseUrl = shindigBaseUrl;
        }

        @Override
        public void run() {
            try {
                new ShindigTester(this.shindigBaseUrl).connect();
                this.ss.info(this.listener, "Shindig service responds to a REST query.");
            }
            catch (ShindigTesterException e) {
                String message = e.getMessage();
                Throwable cause = e.getCause();
                if (cause == null) {
                    this.ss.warning(this.listener, message);
                }
                this.ss.warning(this.listener, message, cause);
            }
        }
    }

    private class Warning {
        private final String message;
        private final Throwable cause;

        Warning(String message) {
            this.message = message;
            this.cause = null;
        }

        Warning(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }

        void warn(StartupStatus ss) {
            if (this.cause == null) {
                ss.warning(OpenSocialSmokeTests.this, this.message);
            } else {
                ss.warning(OpenSocialSmokeTests.this, this.message, this.cause);
            }
        }
    }

    private static class NoSuchPropertyException
    extends Exception {
        NoSuchPropertyException(String key) {
            super("There is no value for '" + key + "' in build.properties");
        }
    }
}

