/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfiguration;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.DataPropertyListConfig;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.DataPropertyStatementTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyTemplateModel;
import freemarker.cache.TemplateLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;

public class DataPropertyTemplateModel
extends PropertyTemplateModel {
    private static final Log log = LogFactory.getLog(DataPropertyTemplateModel.class);
    private static final String TYPE = "data";
    private static final String EDIT_PATH = "editRequestDispatch";
    private final List<DataPropertyStatementTemplateModel> statements;
    private static final String KEY_SUBJECT = "subject";
    private static final String KEY_PROPERTY = "property";
    private DataPropertyListConfig config;
    private String objectKey;
    private String queryString;
    private String publicDescription;
    private String rangeDatatypeURI;
    private Set<String> constructQueries;
    private int displayLimit;

    DataPropertyTemplateModel(DataProperty dp, Individual subject, VitroRequest vreq, boolean editing, List<DataProperty> populatedDataPropertyList) {
        super(dp, subject, vreq, dp.getPublicName());
        try {
            this.config = new DataPropertyListConfig(this, this.getFreemarkerTemplateLoader(), vreq, dp, editing);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        this.queryString = this.getSelectQuery();
        this.constructQueries = this.getConstructQueries();
        this.publicDescription = dp.getPublicDescription();
        this.statements = new ArrayList<DataPropertyStatementTemplateModel>();
        this.displayLimit = dp.getDisplayLimit();
        this.rangeDatatypeURI = dp.getRangeDatatypeURI();
        if (populatedDataPropertyList.contains(dp)) {
            log.debug((Object)("Getting data for populated data property " + this.getUri()));
            DataPropertyStatementDao dpDao = vreq.getWebappDaoFactory().getDataPropertyStatementDao();
            List<Literal> values = dpDao.getDataPropertyValuesForIndividualByProperty(subject, dp, this.queryString, this.constructQueries);
            for (Literal value : values) {
                this.statements.add(new DataPropertyStatementTemplateModel(this.subjectUri, dp, value, this.getTemplateName(), vreq));
            }
        } else {
            log.debug((Object)("Data property " + this.getUri() + " is unpopulated."));
        }
        if (editing) {
            this.setAddUrl(dp);
        }
    }

    protected void setAddUrl(Property property) {
        DataProperty dp = (DataProperty)property;
        if (dp.getURI().equals("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#moniker")) {
            return;
        }
        boolean functional = dp.getFunctional();
        if (functional && this.statements.size() >= 1) {
            return;
        }
        AddDataPropertyStatement action = new AddDataPropertyStatement(this.vreq.getJenaOntModel(), this.subjectUri, this.propertyUri, RequestedAction.SOME_LITERAL);
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{action})) {
            return;
        }
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("subjectUri", this.subjectUri, "predicateUri", this.propertyUri);
        params.putAll(UrlBuilder.getModelParams(this.vreq));
        this.addUrl = UrlBuilder.getUrl(EDIT_PATH, params);
    }

    protected TemplateLoader getFreemarkerTemplateLoader() {
        return FreemarkerConfiguration.getConfig((HttpServletRequest)this.vreq).getTemplateLoader();
    }

    @Override
    protected int getPropertyDisplayTier(Property p) {
        return ((DataProperty)p).getDisplayTier();
    }

    @Override
    protected UrlBuilder.Route getPropertyEditRoute() {
        return UrlBuilder.Route.DATA_PROPERTY_EDIT;
    }

    public String getPublicDescription() {
        return this.publicDescription;
    }

    @Override
    public int getDisplayLimit() {
        return this.displayLimit;
    }

    public String getRangeDatatypeURI() {
        return this.rangeDatatypeURI;
    }

    public ConfigError checkQuery(String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return ConfigError.NO_SELECT_QUERY;
        }
        return null;
    }

    private String getSelectQuery() {
        return this.config.getSelectQuery();
    }

    private Set<String> getConstructQueries() {
        return this.config.getConstructQueries();
    }

    protected String getTemplateName() {
        return this.config.getTemplateName();
    }

    protected boolean hasDefaultListView() {
        return this.config.isDefaultListView();
    }

    protected String getObjectKey() {
        return this.objectKey;
    }

    protected boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public List<DataPropertyStatementTemplateModel> getStatements() {
        return this.statements;
    }

    public String getTemplate() {
        return this.getTemplateName();
    }

    public DataPropertyStatementTemplateModel first() {
        return this.statements == null || this.statements.isEmpty() ? null : this.statements.get(0);
    }

    public String firstValue() {
        DataPropertyStatementTemplateModel first = this.first();
        return first == null ? null : first.getValue();
    }

    public static enum ConfigError {
        NO_SELECT_QUERY("Missing select query specification"),
        NO_TEMPLATE("Missing template specification"),
        TEMPLATE_NOT_FOUND("Specified template does not exist");

        String message;

        private ConfigError(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

