/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.CustomListViewConfigFile;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.ListConfigUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.DataPropertyTemplateModel;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataPropertyListConfig {
    private static final Log log = LogFactory.getLog(DataPropertyListConfig.class);
    private static final String CONFIG_FILE_PATH = "/config/";
    private static final String DEFAULT_CONFIG_FILE_NAME = "listViewConfig-dataDefault.xml";
    private final DataPropertyTemplateModel dptm;
    private final VitroRequest vreq;
    private final TemplateLoader templateLoader;
    private boolean isDefaultConfig;
    private Set<String> constructQueries;
    private String selectQuery;
    private String templateName;

    public DataPropertyListConfig(DataPropertyTemplateModel dptm, TemplateLoader templateLoader, VitroRequest vreq, DataProperty dp, boolean editing) throws InvalidConfigurationException {
        DataPropertyTemplateModel.ConfigError configError;
        this.dptm = dptm;
        this.vreq = vreq;
        WebappDaoFactory wadf = vreq.getWebappDaoFactory();
        this.templateLoader = templateLoader;
        String configFileName = wadf.getDataPropertyDao().getCustomListViewConfigFileName(dp);
        if (configFileName == null) {
            configFileName = DEFAULT_CONFIG_FILE_NAME;
        }
        log.debug((Object)("Using list view config file " + configFileName + " for data property " + dp.getURI()));
        String configFilePath = this.getConfigFilePath(configFileName);
        try {
            File config = new File(configFilePath);
            if (!this.isDefaultConfig(configFileName) && !config.exists()) {
                log.warn((Object)("Can't find config file " + configFilePath + " for data property " + dp.getURI() + "\n. Using default config file instead."));
                configFilePath = this.getConfigFilePath(DEFAULT_CONFIG_FILE_NAME);
            }
            this.setValuesFromConfigFile(configFilePath, wadf, editing);
        }
        catch (Exception e) {
            log.error((Object)("Error processing config file " + configFilePath + " for data property " + dp.getURI()), (Throwable)e);
        }
        if (!this.isDefaultConfig(configFileName) && (configError = this.checkConfiguration()) != null) {
            log.warn((Object)("Invalid list view config for data property " + dp.getURI() + " in " + configFilePath + ":\n" + (Object)((Object)configError) + " Using default config instead."));
            configFilePath = this.getConfigFilePath(DEFAULT_CONFIG_FILE_NAME);
            this.setValuesFromConfigFile(configFilePath, wadf, editing);
        }
        this.isDefaultConfig = this.isDefaultConfig(configFileName);
    }

    private boolean isDefaultConfig(String configFileName) {
        return configFileName.equals(DEFAULT_CONFIG_FILE_NAME);
    }

    private DataPropertyTemplateModel.ConfigError checkConfiguration() {
        DataPropertyTemplateModel.ConfigError error = this.dptm.checkQuery(this.selectQuery);
        if (error != null) {
            return error;
        }
        if (StringUtils.isBlank((CharSequence)this.selectQuery)) {
            return DataPropertyTemplateModel.ConfigError.NO_SELECT_QUERY;
        }
        if (StringUtils.isBlank((CharSequence)this.templateName)) {
            return DataPropertyTemplateModel.ConfigError.NO_TEMPLATE;
        }
        try {
            if (this.templateLoader.findTemplateSource(this.templateName) == null) {
                return DataPropertyTemplateModel.ConfigError.TEMPLATE_NOT_FOUND;
            }
        }
        catch (IOException e) {
            log.error((Object)("Error finding template " + this.templateName), (Throwable)e);
        }
        return null;
    }

    private void setValuesFromConfigFile(String configFilePath, WebappDaoFactory wdf, boolean editing) {
        try {
            FileReader reader = new FileReader(configFilePath);
            CustomListViewConfigFile configFileContents = new CustomListViewConfigFile(reader);
            this.selectQuery = configFileContents.getSelectQuery(false, editing, ListConfigUtils.getUsePreciseSubquery(this.vreq));
            this.templateName = configFileContents.getTemplateName();
            this.constructQueries = configFileContents.getConstructQueries();
        }
        catch (Exception e) {
            log.error((Object)("Error processing config file " + configFilePath), (Throwable)e);
        }
    }

    private String getConfigFilePath(String filename) {
        return this.vreq.getSession().getServletContext().getRealPath(CONFIG_FILE_PATH + filename);
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public Set<String> getConstructQueries() {
        return this.constructQueries;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean isDefaultListView() {
        return this.isDefaultConfig;
    }
}

