/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.developer.listeners;

import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.Statement;

public class DeveloperDisabledChangeListener
extends StatementListener
implements ModelChangedListener {
    private final ModelChangedListener inner;
    private final Key disablingKey;

    public DeveloperDisabledChangeListener(ModelChangedListener inner, Key disablingKey) {
        this.inner = inner;
        this.disablingKey = disablingKey;
    }

    private boolean isEnabled() {
        return !DeveloperSettings.getInstance().getBoolean(this.disablingKey);
    }

    public void addedStatement(Statement stmt) {
        if (this.isEnabled()) {
            this.inner.addedStatement(stmt);
        }
    }

    public void removedStatement(Statement stmt) {
        if (this.isEnabled()) {
            this.inner.removedStatement(stmt);
        }
    }

    public void notifyEvent(Model model, Object event) {
        if (this.isEnabled()) {
            this.inner.notifyEvent(model, event);
        }
    }
}

