/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationRdf;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.PropertyType;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockedModel;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;

public class ConfigurationRdfParser {
    public static <T> ConfigurationRdf<T> parse(LockableModel locking, String uri, Class<T> resultClass) throws InvalidConfigurationRdfException {
        Objects.requireNonNull(locking, "locking may not be null.");
        Objects.requireNonNull(uri, "uri may not be null.");
        Objects.requireNonNull(resultClass, "resultClass may not be null.");
        ConfigurationRdfParser.confirmExistenceInModel(locking, uri);
        ConfigurationRdfParser.confirmEligibilityForResultClass(locking, uri, resultClass);
        Set<PropertyType.PropertyStatement> properties = ConfigurationRdfParser.loadProperties(locking, uri);
        Class<T> concreteClass = ConfigurationRdfParser.determineConcreteClass(locking, uri, resultClass);
        return new ConfigurationRdf<T>(concreteClass, properties);
    }

    private static void confirmExistenceInModel(LockableModel locking, String uri) throws InvalidConfigurationRdfException {
        SimpleSelector s = new SimpleSelector(ResourceFactory.createResource((String)uri), null, (RDFNode)null);
        try (LockedModel m = locking.read();){
            if (m.listStatements((Selector)s).toList().isEmpty()) {
                throw ConfigurationRdfParser.individualDoesNotAppearInModel(uri);
            }
        }
    }

    private static void confirmEligibilityForResultClass(LockableModel locking, String uri, Class<?> resultClass) throws InvalidConfigurationRdfException {
        String resultClassUri = ConfigurationBeanLoader.toJavaUri(resultClass);
        try (LockedModel m = locking.read();){
            Set types = m.listObjectsOfProperty(ResourceFactory.createResource((String)uri), RDF.type).toSet();
            for (RDFNode typeNode : types) {
                String typeUri;
                if (!typeNode.isURIResource() || !ConfigurationBeanLoader.isMatchingJavaUri(resultClassUri, typeUri = typeNode.asResource().getURI())) continue;
                return;
            }
            throw ConfigurationRdfParser.noTypeStatementForResultClass(uri, resultClassUri);
        }
    }

    private static Set<PropertyType.PropertyStatement> loadProperties(LockableModel locking, String uri) throws InvalidConfigurationRdfException {
        HashSet<PropertyType.PropertyStatement> set = new HashSet<PropertyType.PropertyStatement>();
        try (LockedModel m = locking.read();){
            List rawStatements = m.listStatements(m.getResource(uri), (Property)null, (RDFNode)null).toList();
            if (rawStatements.isEmpty()) {
                throw ConfigurationRdfParser.noRdfStatements(uri);
            }
            for (Statement s : rawStatements) {
                if (s.getPredicate().equals(RDF.type)) continue;
                try {
                    set.add(PropertyType.createPropertyStatement(s));
                }
                catch (PropertyType.PropertyTypeException e) {
                    throw new InvalidConfigurationRdfException("Invalid property statement on '" + uri + "'", e);
                }
            }
            HashSet<PropertyType.PropertyStatement> hashSet = set;
            return hashSet;
        }
    }

    private static <T> Class<? extends T> determineConcreteClass(LockableModel locking, String uri, Class<T> resultClass) throws InvalidConfigurationRdfException {
        HashSet<Class<T>> concreteClasses = new HashSet<Class<T>>();
        try (LockedModel m = locking.read();){
            for (RDFNode node : m.listObjectsOfProperty(ResourceFactory.createResource((String)uri), RDF.type).toSet()) {
                if (!node.isURIResource()) {
                    throw ConfigurationRdfParser.typeMustBeUriResource(node);
                }
                String typeUri = node.asResource().getURI();
                if (!ConfigurationRdfParser.isConcreteClass(typeUri)) continue;
                concreteClasses.add(ConfigurationRdfParser.processTypeUri(typeUri, resultClass));
            }
        }
        if (concreteClasses.isEmpty()) {
            throw ConfigurationRdfParser.noConcreteClasses(uri);
        }
        if (concreteClasses.size() > 1) {
            throw ConfigurationRdfParser.tooManyConcreteClasses(uri, concreteClasses);
        }
        return (Class)concreteClasses.iterator().next();
    }

    private static boolean isConcreteClass(String typeUri) throws InvalidConfigurationRdfException {
        try {
            if (!ConfigurationBeanLoader.isJavaUri(typeUri)) {
                return false;
            }
            Class<?> clazz = Class.forName(ConfigurationBeanLoader.classnameFromJavaUri(typeUri));
            if (clazz.isInterface()) {
                return false;
            }
            return !Modifier.isAbstract(clazz.getModifiers());
        }
        catch (ClassNotFoundException | ExceptionInInitializerError e) {
            throw ConfigurationRdfParser.failedToLoadClass(typeUri, e);
        }
    }

    private static <T> Class<? extends T> processTypeUri(String typeUri, Class<T> resultClass) throws InvalidConfigurationRdfException {
        try {
            Class<?> clazz = Class.forName(ConfigurationBeanLoader.classnameFromJavaUri(typeUri));
            if (!resultClass.isAssignableFrom(clazz)) {
                throw ConfigurationRdfParser.notAssignable(resultClass, clazz);
            }
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw ConfigurationRdfParser.noZeroArgumentConstructor(clazz);
            }
            catch (SecurityException e) {
                throw ConfigurationRdfParser.constructorNotPublic(clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw ConfigurationRdfParser.failedToLoadClass(typeUri, e);
        }
    }

    private static InvalidConfigurationRdfException individualDoesNotAppearInModel(String uri) {
        return new InvalidConfigurationRdfException("The model contains no statements about '" + uri + "'");
    }

    private static InvalidConfigurationRdfException noConcreteClasses(String uri) {
        return new InvalidConfigurationRdfException("No concrete class is declared for '" + uri + "'");
    }

    private static InvalidConfigurationRdfException tooManyConcreteClasses(String uri, Set<?> concreteClasses) {
        return new InvalidConfigurationRdfException("'" + uri + "' is declared with more than one concrete class: " + concreteClasses);
    }

    private static InvalidConfigurationRdfException notAssignable(Class<?> resultClass, Class<?> clazz) {
        return new InvalidConfigurationRdfException(clazz + " cannot be assigned to " + resultClass);
    }

    private static InvalidConfigurationRdfException noZeroArgumentConstructor(Class<?> clazz) {
        return new InvalidConfigurationRdfException("Can't instantiate '" + clazz + "': no zero-argument constructor.");
    }

    private static InvalidConfigurationRdfException constructorNotPublic(Class<?> clazz) {
        return new InvalidConfigurationRdfException("Can't instantiate '" + clazz + "': zero-argument constructor is not public.");
    }

    private static InvalidConfigurationRdfException failedToLoadClass(String typeUri, Throwable e) {
        return new InvalidConfigurationRdfException("Can't load this type: '" + typeUri + "'", e);
    }

    private static InvalidConfigurationRdfException typeMustBeUriResource(RDFNode node) {
        return new InvalidConfigurationRdfException("Type must be a URI Resource: " + node);
    }

    private static InvalidConfigurationRdfException noTypeStatementForResultClass(String uri, String resultClassUri) {
        return new InvalidConfigurationRdfException("A type statement is required: '" + ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)uri), (Property)RDF.type, (RDFNode)ResourceFactory.createResource((String)resultClassUri)));
    }

    private static InvalidConfigurationRdfException noRdfStatements(String uri) {
        return new InvalidConfigurationRdfException("'" + uri + "' does not appear as the subject of any statements in the model.");
    }

    public static class InvalidConfigurationRdfException
    extends Exception {
        public InvalidConfigurationRdfException(String message) {
            super(message);
        }

        public InvalidConfigurationRdfException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

