/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailUtil {
    private static final Log log = LogFactory.getLog(MailUtil.class);
    private final HttpServletRequest req;

    public MailUtil(HttpServletRequest req) {
        this.req = req;
    }

    public void sendMessage(String messageText, String subject, String from, String to, List<String> deliverToArray) throws IOException {
        Session s = FreemarkerEmailFactory.getEmailSession(this.req);
        try {
            int recipientCount;
            int n = recipientCount = deliverToArray == null ? 0 : deliverToArray.size();
            if (recipientCount == 0) {
                log.error((Object)"To establish the Contact Us mail capability the system administrators must  specify at least one email address in the current portal.");
            }
            MimeMessage msg = new MimeMessage(s);
            msg.setFrom((Address)new InternetAddress(from));
            if (recipientCount > 0) {
                InternetAddress[] address = new InternetAddress[recipientCount];
                for (int i = 0; i < recipientCount; ++i) {
                    address[i] = new InternetAddress(deliverToArray.get(i));
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            }
            msg.setSubject(subject);
            msg.setContent((Object)messageText, "text/html; charset=UTF-8");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception ex) {
            log.error((Object)("Exception sending message :" + ex.getMessage()), (Throwable)ex);
        }
    }
}

