/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class JsonToFmModel {
    public static String ROOT_ARRAY = "root";

    public static Map<String, Object> convertJSONObjectToMap(ObjectNode jo) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Iterator itr = jo.fieldNames();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            JsonNode o = jo.get(key);
            if (o instanceof ObjectNode) {
                model.put(key, JsonToFmModel.convertJSONObjectToMap((ObjectNode)o));
                continue;
            }
            if (o instanceof ArrayNode) {
                model.put(key, JsonToFmModel.convertJSONArrayToList((ArrayNode)o));
                continue;
            }
            model.put(key, o);
        }
        return model;
    }

    public static List<Object> convertJSONArrayToList(ArrayNode ja) {
        ArrayList<Object> model = new ArrayList<Object>();
        for (int i = 0; i < ja.size(); ++i) {
            JsonNode o = ja.get(i);
            if (o instanceof ArrayNode) {
                model.add(JsonToFmModel.convertJSONArrayToList((ArrayNode)o));
                continue;
            }
            if (o instanceof ObjectNode) {
                model.add(JsonToFmModel.convertJSONObjectToMap((ObjectNode)o));
                continue;
            }
            model.add(o);
        }
        return model;
    }

    public static String toString(Map<String, Object> map) {
        return JsonToFmModel.toStringBuffer(map, 0).toString();
    }

    private static StringBuffer toStringBuffer(Map<String, Object> unsortedMap, int indent) {
        StringBuilder tabs = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            tabs.append("\t");
        }
        StringBuffer sb = new StringBuffer();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.putAll(unsortedMap);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                sb.append((CharSequence)tabs).append((String)entry.getKey()).append(":").append(entry.getValue().getClass()).append("\n");
                sb.append(JsonToFmModel.toStringBuffer((Map)entry.getValue(), indent + 1));
                continue;
            }
            if (entry.getValue() instanceof List) {
                sb.append((CharSequence)tabs).append("[\n");
                List l = (List)entry.getValue();
                for (Object aL : l) {
                    sb.append((CharSequence)tabs).append(aL).append(":").append(aL != null ? aL.getClass() : "null").append("\n");
                }
                sb.append((CharSequence)tabs).append("]\n");
                continue;
            }
            sb.append((CharSequence)tabs).append((String)entry.getKey()).append(":").append(entry.getValue()).append(":").append(entry.getValue() != null ? entry.getValue().getClass() : "null").append("\n");
        }
        return sb;
    }
}

