/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrontEndEditingUtils {
    private static final Log log = LogFactory.getLog(FrontEndEditingUtils.class);

    public static EditMode getEditMode(HttpServletRequest request, String relatedPropertyUri) {
        Individual obj = (Individual)request.getAttribute("object");
        return FrontEndEditingUtils.getEditMode(request, obj, relatedPropertyUri);
    }

    public static EditMode getEditMode(HttpServletRequest request, Individual obj, String relatedPropertyUri) {
        EditMode mode = EditMode.ADD;
        if (obj != null) {
            List<ObjectPropertyStatement> stmts = obj.getObjectPropertyStatements(relatedPropertyUri);
            if (stmts != null) {
                if (stmts.size() > 1) {
                    mode = EditMode.ERROR;
                    log.debug((Object)("Multiple statements found for property " + relatedPropertyUri + ". Setting edit mode to ERROR."));
                } else if (stmts.size() == 0) {
                    mode = EditMode.REPAIR;
                    log.debug((Object)("No statements found for property " + relatedPropertyUri + ". Setting edit mode to REPAIR."));
                } else if (stmts.size() == 1) {
                    mode = EditMode.EDIT;
                    log.debug((Object)("Single statement found for property " + relatedPropertyUri + ". Setting edit mode to EDIT."));
                }
            } else {
                log.debug((Object)("Statements null for property " + relatedPropertyUri + " . Setting edit mode to ADD."));
            }
        } else {
            log.debug((Object)"No object. Setting edit mode to ADD.");
        }
        return mode;
    }

    public static enum EditMode {
        ADD,
        EDIT,
        REPAIR,
        ERROR;

    }
}

