/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class Csv2Rdf {
    private String namespace;
    private String tboxNamespace;
    private String typeName;
    private String individualNameBase;
    private String propertyNameBase;
    private char separatorChar;
    private char quoteChar;

    public Csv2Rdf(char quoteChar, String namespace, String tboxNamespace, String typeName) {
        this.separatorChar = (char)44;
        this.quoteChar = quoteChar;
        this.namespace = namespace;
        this.tboxNamespace = tboxNamespace;
        this.typeName = typeName;
        this.individualNameBase = typeName.toLowerCase();
        this.propertyNameBase = this.individualNameBase + "_";
    }

    public Csv2Rdf(char separatorChar, char quoteChar, String namespace, String tboxNamespace, String typeName) {
        this.separatorChar = separatorChar;
        this.quoteChar = quoteChar;
        this.namespace = namespace;
        this.tboxNamespace = tboxNamespace;
        this.typeName = typeName;
        this.individualNameBase = typeName.toLowerCase();
        this.propertyNameBase = this.individualNameBase + "_";
    }

    public Model[] convertToRdf(InputStream fis) throws IOException {
        return this.convertToRdf(fis, null, null);
    }

    public Model[] convertToRdf(InputStream fis, WebappDaoFactory wadf, Model destination) throws IOException {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel tboxOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ontModel.addSubModel((Model)tboxOntModel);
        OntClass theClass = tboxOntModel.createClass(this.tboxNamespace + this.typeName);
        URIGenerator uriGen = wadf != null && destination != null ? new RandomURIGenerator(wadf, destination) : new SequentialURIGenerator();
        CSVParser cReader = new CSVParser((Reader)new InputStreamReader(fis), CSVFormat.DEFAULT.withRecordSeparator(this.separatorChar).withQuote(this.quoteChar));
        DatatypeProperty[] dpArray = null;
        for (CSVRecord cRecord : cReader) {
            if (dpArray == null) {
                dpArray = new DatatypeProperty[cRecord.size()];
                for (int i = 0; i < dpArray.length; ++i) {
                    dpArray[i] = tboxOntModel.createDatatypeProperty(this.tboxNamespace + this.propertyNameBase + cRecord.get(i).replaceAll("\\W", ""));
                }
                continue;
            }
            Individual ind = null;
            String uri = uriGen.getNextURI();
            ind = uri != null ? ontModel.createIndividual(uri, (Resource)theClass) : ontModel.createIndividual((Resource)theClass);
            for (int col = 0; col < cRecord.size() && col < dpArray.length; ++col) {
                String value = cRecord.get(col).trim();
                if (value.length() <= 0) continue;
                ind.addProperty((Property)dpArray[col], value);
            }
        }
        cReader.close();
        ontModel.removeSubModel((Model)tboxOntModel);
        Model[] resultModels = new Model[]{ontModel, tboxOntModel};
        return resultModels;
    }

    private class SequentialURIGenerator
    implements URIGenerator {
        private int index = 0;

        private SequentialURIGenerator() {
        }

        @Override
        public String getNextURI() {
            ++this.index;
            return Csv2Rdf.this.namespace + Csv2Rdf.this.individualNameBase + Integer.toString(this.index);
        }
    }

    private class RandomURIGenerator
    implements URIGenerator {
        private WebappDaoFactory wadf;
        private Model destination;
        private Random random = new Random(System.currentTimeMillis());

        public RandomURIGenerator(WebappDaoFactory webappDaoFactory, Model destination) {
            this.wadf = webappDaoFactory;
            this.destination = destination;
        }

        @Override
        public String getNextURI() {
            boolean uriIsGood = false;
            boolean inDestination = false;
            String uri = null;
            if (Csv2Rdf.this.namespace != null && !Csv2Rdf.this.namespace.isEmpty()) {
                for (int attempts = 0; !uriIsGood && attempts < 30; ++attempts) {
                    uri = Csv2Rdf.this.namespace + Csv2Rdf.this.individualNameBase + this.random.nextInt(Math.min(Integer.MAX_VALUE, (int)Math.pow(2.0, attempts + 13)));
                    String errMsg = this.wadf.checkURI(uri);
                    Resource res = ResourceFactory.createResource((String)uri);
                    inDestination = this.destination.contains(res, null);
                    if (errMsg != null && !inDestination) {
                        uri = null;
                        continue;
                    }
                    uriIsGood = true;
                }
            }
            return uri;
        }
    }

    private static interface URIGenerator {
        public String getNextURI();
    }
}

